/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dict.system.repository.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.authority.common.rsp.DictPage;
import com.ohaotian.authority.common.rsp.DictResult;
import com.tydic.dict.system.repository.dao.DictMessageTemplateMapper;
import com.tydic.dict.system.repository.po.DictBasePO;
import com.tydic.dict.system.repository.po.DictMessageTemplatePO;
import com.tydic.dict.system.repository.service.search.DictMessageTemplateSearchService;
import com.tydic.dict.system.service.bo.DictMessageTemplateQueryBo;
import com.tydic.dict.system.service.bo.DictMessageTemplateReaderBo;
import com.tydic.dict.system.service.bo.DictMessageTemplateRspBO;
import com.tydic.dict.system.service.common.ExcelUtil;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.FileCopyUtils;

@Service
public class DictMessageTemplateSearchServiceImpl
extends ServiceImpl<DictMessageTemplateMapper, DictMessageTemplatePO>
implements DictMessageTemplateSearchService {
    private static final Logger log = LoggerFactory.getLogger(DictMessageTemplateSearchServiceImpl.class);
    @Autowired
    private DictMessageTemplateMapper dictMessageTemplateMapper;
    @Autowired
    private Configuration freemarkerConfig;
    @Autowired
    ExcelUtil excelUtil;
    private static final int BATCH_SIZE = 100;
    private static int ROW_NUM = 1;
    private static final String BASE_PATH = "dict-manage-infrastructure/src/main/resources/messageTemplate";
    private static final String ERROR_MESSAGE_BASE_PATH = "dict-manage-infrastructure/src/main/resources/messageTemplate/errorMessage.xlsx";
    private static final String MESSAGE_TEMPLATE_FILENAME = "messageTemplate.xlsx";

    @Override
    public DictResult<DictPage> pageQuery(DictMessageTemplateQueryBo reqBo) {
        Page page = (Page)this.dictMessageTemplateMapper.selectPage((IPage)new Page((long)reqBo.getPageNo(), (long)reqBo.getPageSize()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DictBasePO::getDeleted, (Object)false)).like(ObjectUtil.isNotEmpty((Object)reqBo.getName()), DictMessageTemplatePO::getName, (Object)reqBo.getName())).eq(ObjectUtil.isNotEmpty((Object)reqBo.getCode()), DictMessageTemplatePO::getCode, (Object)reqBo.getCode())).eq(ObjectUtil.isNotEmpty((Object)reqBo.getType()), DictMessageTemplatePO::getType, (Object)reqBo.getType())).eq(ObjectUtil.isNotEmpty((Object)reqBo.getScene()), DictMessageTemplatePO::getScene, (Object)reqBo.getScene()));
        if (page != null) {
            DictPage poDictPage = DictPage.newInstance((int)reqBo.getPageNo(), (int)reqBo.getPageSize(), (List)page.getRecords(), (long)page.getTotal());
            return DictResult.success((Object)poDictPage);
        }
        return DictResult.error(null, (String)"\u67e5\u8be2\u5931\u8d25");
    }

    @Override
    public List<String> getTypeList() {
        List dictMessageTemplatePOS = this.dictMessageTemplateMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(DictBasePO::getDeleted, (Object)false));
        List<String> types = dictMessageTemplatePOS.stream().map(DictMessageTemplatePO::getType).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        return types;
    }

    @Override
    public List<String> getSceneList() {
        List dictMessageTemplatePOS = this.dictMessageTemplateMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(DictBasePO::getDeleted, (Object)false));
        List<String> scenes = dictMessageTemplatePOS.stream().map(DictMessageTemplatePO::getScene).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        return scenes;
    }

    @Override
    public DictMessageTemplateRspBO render(DictMessageTemplateReaderBo readerBo) {
        if (readerBo.getId() == null || ObjectUtil.isEmpty((Object)readerBo.getParams())) {
            return null;
        }
        DictMessageTemplatePO dictMessageTemplatePO = (DictMessageTemplatePO)this.dictMessageTemplateMapper.selectById(readerBo.getId());
        ObjectMapper mapper = new ObjectMapper();
        Map map = null;
        try {
            map = (Map)mapper.readValue(readerBo.getParams(), Map.class);
        }
        catch (JsonProcessingException e) {
            log.error("JSON\u8f6cmap\u51fa\u73b0error: {}", (Object)e.getMessage());
        }
        if (ObjectUtil.isEmpty((Object)map)) {
            return (DictMessageTemplateRspBO)BeanUtil.copyProperties((Object)dictMessageTemplatePO, DictMessageTemplateRspBO.class);
        }
        String templateContent = dictMessageTemplatePO.getContent();
        templateContent = this.convertTemplateSyntax(templateContent);
        Template template = null;
        try {
            template = new Template("templateMessage", templateContent, this.freemarkerConfig);
        }
        catch (IOException e) {
            log.error("\u6a21\u7248\u5bf9\u8c61\u521b\u5efaerror: {}", (Object)e.getMessage());
        }
        StringWriter writer = new StringWriter();
        try {
            template.process((Object)map, (Writer)writer);
        }
        catch (Exception e) {
            log.error("\u6a21\u7248\u6e32\u67d3error: {}", (Object)e.getMessage());
        }
        templateContent = writer.toString();
        templateContent = DictMessageTemplateSearchServiceImpl.evaluateExpressions(templateContent);
        dictMessageTemplatePO.setContent(templateContent);
        return (DictMessageTemplateRspBO)BeanUtil.copyProperties((Object)dictMessageTemplatePO, DictMessageTemplateRspBO.class);
    }

    private String convertTemplateSyntax(String template) {
        Pattern pattern = Pattern.compile("\\{([^{}]+)\\}");
        Matcher matcher = pattern.matcher(template);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String content = matcher.group(1);
            matcher.appendReplacement(result, "\\$\\{" + content + "\\}");
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static String evaluateExpressions(String input) {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("JavaScript");
        Pattern pattern = Pattern.compile("\\d+\\s*[-+*/]\\s*\\d+");
        Matcher matcher = pattern.matcher(input);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String expression = matcher.group();
            try {
                Object evalResult = engine.eval(expression);
                matcher.appendReplacement(result, evalResult.toString());
            }
            catch (Exception e) {
                matcher.appendReplacement(result, matcher.group());
                log.error("\u8ba1\u7b97\u8868\u8fbe\u5f0f\u5931\u8d25: {}", (Object)e.getMessage());
            }
        }
        matcher.appendTail(result);
        return result.toString();
    }

    @Override
    public Boolean exportMessageTemplate(HttpServletResponse response) {
        try {
            List templatePOList = this.dictMessageTemplateMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(DictBasePO::getDeleted, (Object)false));
            List<String> excludeColumns = Arrays.asList("id", "updatedBy", "updatedTime", "createdTime", "createdBy", "deleted");
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode("\u6d88\u606f\u6a21\u677f", "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            ((ExcelWriterSheetBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), DictMessageTemplatePO.class).sheet(fileName).excludeColumnFieldNames(excludeColumns)).doWrite((Collection)templatePOList);
            return true;
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u6d88\u606f\u6a21\u7248\u5931\u8d25: {}", (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public Boolean downloadMessageTemplate(HttpServletResponse response) {
        Path filePath = Paths.get(BASE_PATH, MESSAGE_TEMPLATE_FILENAME);
        File file = filePath.toFile();
        if (!file.exists()) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            try {
                response.getWriter().write("\u6587\u4ef6\u672a\u627e\u5230");
            }
            catch (Exception e) {
                log.error("\u4e0b\u8f7d\u6d88\u606f\u6a21\u7248\u5931\u8d25: {}", (Object)e.getMessage());
                return false;
            }
        }
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + file.getName() + "\"");
        try {
            FileCopyUtils.copy((InputStream)new FileSystemResource(file).getInputStream(), (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            log.error("\u4e0b\u8f7d\u6d88\u606f\u6a21\u7248\u5931\u8d25: {}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public Boolean downloadErrorMessageTemplate(HttpServletResponse response) {
        Path filePath = Paths.get(ERROR_MESSAGE_BASE_PATH, new String[0]);
        File file = filePath.toFile();
        if (!file.exists()) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            try {
                response.getWriter().write("\u6587\u4ef6\u672a\u627e\u5230");
            }
            catch (Exception e) {
                log.error("\u9519\u8bef\u62a5\u544a\u4e0b\u8f7d\u5931\u8d25: {}", (Object)e.getMessage());
                return false;
            }
        }
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + file.getName() + "\"");
        try {
            FileCopyUtils.copy((InputStream)new FileSystemResource(file).getInputStream(), (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            log.error("\u9519\u8bef\u62a5\u544a\u4e0b\u8f7d\u5931\u8d25: {}", (Object)e.getMessage());
            return false;
        }
        return true;
    }
}

