/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dict.system.repository.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tydic.dict.system.repository.dao.DictAuditTodoMapper;
import com.tydic.dict.system.repository.rsp.AuditTodoListResponse;
import com.tydic.dict.system.repository.service.search.DictAuditTodoSearchService;
import com.tydic.dict.system.service.bo.DictAuditTodoQryReqBO;
import com.tydic.dict.system.service.bo.DictAuditTodoRspBO;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictAuditTodoSearchServiceImpl
implements DictAuditTodoSearchService {
    @Autowired
    private DictAuditTodoMapper dictAuditTodoMapper;

    @Override
    public AuditTodoListResponse<DictAuditTodoRspBO> list(DictAuditTodoQryReqBO bo) {
        Page page = new Page((long)bo.getPageNo(), (long)bo.getPageSize());
        Page<DictAuditTodoRspBO> pageResult = this.dictAuditTodoMapper.page(bo, (Page<DictAuditTodoRspBO>)page);
        Map<String, Long> statusCounts = this.dictAuditTodoMapper.countByStatus();
        int pageNo = (int)pageResult.getCurrent();
        int pageSize = (int)pageResult.getSize();
        List records = pageResult.getRecords();
        long total = pageResult.getTotal();
        long todoCount = statusCounts.getOrDefault("todo_count", 0L);
        long doneCount = statusCounts.getOrDefault("done_count", 0L);
        AuditTodoListResponse<DictAuditTodoRspBO> response = AuditTodoListResponse.newInstance(pageNo, pageSize, records, total, todoCount, doneCount);
        return response;
    }
}

