/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dict.system.repository.impl;

import com.tydic.dict.system.repository.dao.DictDictionariesMapper;
import com.tydic.dict.system.repository.po.DictDictionariesPO;
import com.tydic.dict.system.repository.service.update.DictDictionaryUpdateService;
import com.tydic.dict.system.service.bo.DictDictionaryAddReqBO;
import com.tydic.dict.system.service.bo.DictDictionaryDelReqBO;
import com.tydic.dict.system.service.bo.DictDictionaryUpdateReqBO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictDictionaryUpdateServiceImpl
implements DictDictionaryUpdateService {
    @Autowired
    private DictDictionariesMapper dictDictionariesMapper;

    @Override
    public void add(DictDictionaryAddReqBO reqBO) {
        DictDictionariesPO dictDictionariesPO = this.dictDictionariesMapper.selectByDicKey(reqBO.getDicKey());
        if (Objects.nonNull(dictDictionariesPO)) {
            throw new RuntimeException("\u5df2\u5b58\u5728 dicKey: " + dictDictionariesPO.getDicKey());
        }
        dictDictionariesPO = new DictDictionariesPO();
        dictDictionariesPO.setModuleName(reqBO.getModuleName());
        dictDictionariesPO.setDicDir(reqBO.getDicDir());
        dictDictionariesPO.setParentDicKey(reqBO.getParentDicKey());
        dictDictionariesPO.setDicKey(reqBO.getDicKey());
        dictDictionariesPO.setDicValue(reqBO.getDicValue());
        dictDictionariesPO.setOrder(reqBO.getOrder());
        dictDictionariesPO.setStatus(0);
        dictDictionariesPO.setRemark(reqBO.getRemark());
        dictDictionariesPO.setCreateTime(new Date());
        this.dictDictionariesMapper.insert(dictDictionariesPO);
    }

    @Override
    public void update(DictDictionaryUpdateReqBO reqBO) {
        if (Objects.nonNull(reqBO) && StringUtils.isNotBlank((CharSequence)reqBO.getDicKey()) && StringUtils.isNotBlank((CharSequence)reqBO.getDicValue())) {
            this.dictDictionariesMapper.updateDic(reqBO);
        }
    }

    @Override
    public void delete(DictDictionaryDelReqBO reqBO) {
        List<String> dicKeys;
        if (Objects.nonNull(reqBO) && CollectionUtils.isNotEmpty((Collection)reqBO.getDicKeys()) && CollectionUtils.isNotEmpty(dicKeys = reqBO.getDicKeys().stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList()))) {
            this.dictDictionariesMapper.deleteDic(dicKeys);
        }
    }
}

