/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dict.system.repository.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tydic.dict.system.repository.dao.DictMessageCenterInfoMapper;
import com.tydic.dict.system.repository.rsp.MessageTodoListResponse;
import com.tydic.dict.system.repository.service.search.DictMessageCenterInfoSearchService;
import com.tydic.dict.system.service.bo.DictMessageCenterInfoDetailReqBO;
import com.tydic.dict.system.service.bo.DictMessageCenterInfoListReqBO;
import com.tydic.dict.system.service.bo.DictMessageCenterInfoRspBO;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictMessageCenterInfoSearchServiceImpl
implements DictMessageCenterInfoSearchService {
    @Autowired
    private DictMessageCenterInfoMapper dictMessageCenterInfoMapper;

    @Override
    public MessageTodoListResponse<DictMessageCenterInfoRspBO> list(DictMessageCenterInfoListReqBO reqBO) {
        Page page = new Page((long)reqBO.getPageNo(), (long)reqBO.getPageSize());
        Page<DictMessageCenterInfoRspBO> pageResult = this.dictMessageCenterInfoMapper.page(reqBO, (Page<DictMessageCenterInfoRspBO>)page);
        Map<String, Long> statusCounts = this.dictMessageCenterInfoMapper.countByStatus();
        int pageNo = (int)pageResult.getCurrent();
        int pageSize = (int)pageResult.getSize();
        List records = pageResult.getRecords();
        long total = pageResult.getTotal();
        long unreadCount = statusCounts.getOrDefault("unread_count", 0L);
        long readCount = statusCounts.getOrDefault("read_count", 0L);
        MessageTodoListResponse<DictMessageCenterInfoRspBO> response = MessageTodoListResponse.newInstance(pageNo, pageSize, records, total, unreadCount, readCount);
        return response;
    }

    @Override
    public DictMessageCenterInfoRspBO detail(DictMessageCenterInfoDetailReqBO reqBO) {
        DictMessageCenterInfoRspBO rspBO = null;
        if (Objects.nonNull(reqBO.getId())) {
            rspBO = this.dictMessageCenterInfoMapper.detail(reqBO.getId());
        }
        return rspBO;
    }
}

