/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dict.system.repository.util;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PasswordGenerator {
    private static final String LOWER_CASE = "abcdefghijklmnopqrstuvwxyz";
    private static final String UPPER_CASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String NUMBERS = "0123456789";
    private static final String SPECIAL_CHARACTERS = "!@#$%^&*";

    public static String generatePassword() {
        Random random = new Random();
        StringBuilder passwordBuilder = new StringBuilder();
        passwordBuilder.append(PasswordGenerator.getRandomCharacter(LOWER_CASE, random));
        passwordBuilder.append(PasswordGenerator.getRandomCharacter(UPPER_CASE, random));
        passwordBuilder.append(PasswordGenerator.getRandomCharacter(NUMBERS, random));
        passwordBuilder.append(PasswordGenerator.getRandomCharacter(SPECIAL_CHARACTERS, random));
        String allCategories = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*";
        for (int remainingLength = 8 - passwordBuilder.length(); remainingLength > 0; --remainingLength) {
            passwordBuilder.append(PasswordGenerator.getRandomCharacter(allCategories, random));
        }
        List shuffledChars = IntStream.range(0, passwordBuilder.length()).mapToObj(i -> Character.valueOf(passwordBuilder.charAt(i))).collect(Collectors.toList());
        Collections.shuffle(shuffledChars);
        return shuffledChars.stream().map(String::valueOf).collect(Collectors.joining());
    }

    private static char getRandomCharacter(String category, Random random) {
        int index = random.nextInt(category.length());
        return category.charAt(index);
    }
}

