package com.tydic.dict.system.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dict.system.repository.po.DictAuditTaskTodoPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：待办任务信息表
 * 
 * @author zhouyi
 * @date 2024-09-23 16:58
 **/
@Mapper
@Repository
public interface DictAuditTaskTodoMapper {

	/**
	 * 插入单条数据
	 *
	 * @param dictAuditTaskTodoPo 参数对象
	 * @return int 影响数量
	 */
	int insert(DictAuditTaskTodoPO dictAuditTaskTodoPo);

	/**
	 * 根据条件删除数据
	 *
	 * @param dictAuditTaskTodoPo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(DictAuditTaskTodoPO dictAuditTaskTodoPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param dictAuditTaskTodoPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(DictAuditTaskTodoPO dictAuditTaskTodoPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") DictAuditTaskTodoPO set, @Param("where") DictAuditTaskTodoPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param dictAuditTaskTodoPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(DictAuditTaskTodoPO dictAuditTaskTodoPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param dictAuditTaskTodoPo 参数对象
	 * @return DictAuditTaskTodoPO 结果对象
	 */
	DictAuditTaskTodoPO getModelBy(DictAuditTaskTodoPO dictAuditTaskTodoPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param dictAuditTaskTodoPo 参数对象
	 * @return List<DictAuditTaskTodoPO> 结果对象
	 */
	List<DictAuditTaskTodoPO> getList(DictAuditTaskTodoPO dictAuditTaskTodoPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param dictAuditTaskTodoPo 参数对象
	 * @param page 分页参数
	 * @return List<DictAuditTaskTodoPO> 结果对象
	 */
	List<DictAuditTaskTodoPO> getListPage(DictAuditTaskTodoPO dictAuditTaskTodoPo, Page<DictAuditTaskTodoPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<DictAuditTaskTodoPO> list);

}
