package com.tydic.dict.system.repository.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tydic.dict.system.repository.dao.DictAuditTodoMapper;
import com.tydic.dict.system.repository.rsp.AuditTodoListResponse;
import com.tydic.dict.system.repository.service.search.DictAuditTodoSearchService;
import com.tydic.dict.system.service.bo.DictAuditTodoQryReqBO;
import com.tydic.dict.system.service.bo.DictAuditTodoRspBO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service
public class DictAuditTodoSearchServiceImpl implements DictAuditTodoSearchService {

    @Autowired
    private DictAuditTodoMapper dictAuditTodoMapper;

    @Override
    public AuditTodoListResponse<DictAuditTodoRspBO> list(DictAuditTodoQryReqBO bo) {
        // 创建分页对象
        Page<DictAuditTodoRspBO> page = new Page<>(bo.getPageNo(), bo.getPageSize());

        // 执行分页查询
        Page<DictAuditTodoRspBO> pageResult = dictAuditTodoMapper.page(bo, page);

        // 获取待办和已办数量
        Map<String, Long> statusCounts = dictAuditTodoMapper.countByStatus();

        // 封装结果
        int pageNo = (int) pageResult.getCurrent();
        int pageSize = (int) pageResult.getSize();
        List<DictAuditTodoRspBO> records = pageResult.getRecords();
        long total = pageResult.getTotal();
        long todoCount = statusCounts.getOrDefault("todo_count", 0L);
        long doneCount = statusCounts.getOrDefault("done_count", 0L);

        AuditTodoListResponse<DictAuditTodoRspBO> response = AuditTodoListResponse.newInstance(pageNo, pageSize, records, total, todoCount, doneCount);
        return response;
    }
}
