package com.tydic.dict.system.repository.impl;

import com.tydic.dict.system.repository.dao.DictDictionariesMapper;
import com.tydic.dict.system.repository.po.DictDictionariesPO;
import com.tydic.dict.system.repository.service.update.DictDictionaryUpdateService;
import com.tydic.dict.system.service.bo.DictDictionaryAddReqBO;
import com.tydic.dict.system.service.bo.DictDictionaryDelReqBO;
import com.tydic.dict.system.service.bo.DictDictionaryUpdateReqBO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class DictDictionaryUpdateServiceImpl implements DictDictionaryUpdateService {

    @Autowired
    private DictDictionariesMapper dictDictionariesMapper;

    @Override
    public void add(DictDictionaryAddReqBO reqBO) {
        DictDictionariesPO dictDictionariesPO = dictDictionariesMapper.selectByDicKey(reqBO.getDicKey());

        if (Objects.nonNull(dictDictionariesPO)) {
            throw new RuntimeException("已存在 dicKey: " + dictDictionariesPO.getDicKey());
        }
        dictDictionariesPO = new DictDictionariesPO();
        dictDictionariesPO.setModuleName(reqBO.getModuleName());
        dictDictionariesPO.setDicDir(reqBO.getDicDir());
        dictDictionariesPO.setParentDicKey(reqBO.getParentDicKey());
        dictDictionariesPO.setDicKey(reqBO.getDicKey());
        dictDictionariesPO.setDicValue(reqBO.getDicValue());
        dictDictionariesPO.setOrder(reqBO.getOrder());
        dictDictionariesPO.setStatus(0);
        dictDictionariesPO.setRemark(reqBO.getRemark());
        dictDictionariesPO.setCreateTime(new Date());
        dictDictionariesMapper.insert(dictDictionariesPO);
    }

    @Override
    public void update(DictDictionaryUpdateReqBO reqBO) {
        if (Objects.nonNull(reqBO)) {
            if (StringUtils.isNotBlank(reqBO.getDicKey()) && StringUtils.isNotBlank(reqBO.getDicValue())) {
                dictDictionariesMapper.updateDic(reqBO);
            }
        }
    }

    @Override
    public void delete(DictDictionaryDelReqBO reqBO) {
        if (Objects.nonNull(reqBO)) {
            if (CollectionUtils.isNotEmpty(reqBO.getDicKeys())) {
                List<String> dicKeys = reqBO.getDicKeys().stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(dicKeys)) {
                    dictDictionariesMapper.deleteDic(dicKeys);
                }
            }
        }
    }
}
