package com.tydic.dict.system.repository.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ohaotian.authority.common.rsp.DictResult;
import com.tydic.dict.system.repository.dao.DictEnumConfigMapper;
import com.tydic.dict.system.repository.po.DictEnumConfigPo;
import com.tydic.dict.system.repository.service.search.DictEnumConfigSearchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictEnumConfigSearchServiceImpl extends ServiceImpl<DictEnumConfigMapper, DictEnumConfigPo> implements DictEnumConfigSearchService {

    @Autowired
    private DictEnumConfigMapper dictEnumConfigMapper;

    @Override
    public DictResult<DictEnumConfigPo> detail(Long id) {
        if (id != null) {
            DictEnumConfigPo po = dictEnumConfigMapper.selectById(id);
            if (po != null) {
                return DictResult.success(po);
            }
            return DictResult.error(null, "未查询到数据");
        }
        return DictResult.error(null, "无效的参数");
    }

}
