package com.tydic.dict.system.repository.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ohaotian.authority.common.rsp.DictResult;
import com.tydic.dict.system.repository.dao.DictEnumConfigMapper;
import com.tydic.dict.system.repository.po.DictEnumConfigPo;
import com.tydic.dict.system.repository.service.update.DictEnumConfigUpdateService;
import com.tydic.dict.system.service.bo.DictEnumConfigReqBo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class DictEnumConfigUpdateServiceImpl extends ServiceImpl<DictEnumConfigMapper, DictEnumConfigPo> implements DictEnumConfigUpdateService {

    @Autowired
    private DictEnumConfigMapper dictEnumConfigMapper;

    @Override
    public DictResult<String> add(DictEnumConfigReqBo req) {
        DictEnumConfigPo po = BeanUtil.copyProperties(req, DictEnumConfigPo.class);
        // todo 后续需要修改
        //po.setCreatedBy(req.getName());
        //po.setUpdatedBy(req.getName());
        po.setUpdatedBy("admin");
        po.setCreatedBy("admin");
        int insertResult = dictEnumConfigMapper.insert(po);
        if (insertResult <= 0) {
            return DictResult.error(null, "新增失败");
        }
        return DictResult.success("新增成功");
    }

    @Override
    public DictResult<String> updateEnum(DictEnumConfigReqBo req) {
        DictEnumConfigPo enumConfigPo = dictEnumConfigMapper.selectById(req.getId());
        if (enumConfigPo == null) {
            return DictResult.error(null, "未查询到数据");
        }
        BeanUtil.copyProperties(enumConfigPo, enumConfigPo);
        enumConfigPo.setUpdatedTime(new Date());
        // todo 后续需要修改
        //enumConfigPo.setUpdatedBy(req.getName());
        enumConfigPo.setUpdatedBy("admin");
        int result = dictEnumConfigMapper.updateById(enumConfigPo);
        if (result <= 0) {
            return DictResult.error(null, "修改失败");
        }
        return DictResult.success("修改成功");
    }

    @Override
    public DictResult<String> delete(Long id) {
        if (id != null) {
            int result = dictEnumConfigMapper.deleteById(id);
            if (result <= 0) {
                return DictResult.error(null, "删除失败");
            }
            return DictResult.success("删除成功");
        }
        return DictResult.error(null, "无效的参数");
    }
}
