package com.tydic.dict.system.repository.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.authority.common.rsp.DictPage;
import com.tydic.dict.system.repository.dao.DictMessageCenterInfoMapper;
import com.tydic.dict.system.repository.rsp.AuditTodoListResponse;
import com.tydic.dict.system.repository.rsp.MessageTodoListResponse;
import com.tydic.dict.system.repository.service.search.DictMessageCenterInfoSearchService;
import com.tydic.dict.system.service.bo.DictAuditTodoRspBO;
import com.tydic.dict.system.service.bo.DictMessageCenterInfoDetailReqBO;
import com.tydic.dict.system.service.bo.DictMessageCenterInfoListReqBO;
import com.tydic.dict.system.service.bo.DictMessageCenterInfoRspBO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Objects;

@Service
public class DictMessageCenterInfoSearchServiceImpl implements DictMessageCenterInfoSearchService {

    @Autowired
    private DictMessageCenterInfoMapper dictMessageCenterInfoMapper;

    @Override
    public MessageTodoListResponse<DictMessageCenterInfoRspBO> list(DictMessageCenterInfoListReqBO reqBO) {
        // 创建分页对象
        Page<DictMessageCenterInfoRspBO> page = new Page<>(reqBO.getPageNo(), reqBO.getPageSize());

        // 执行分页查询
        Page<DictMessageCenterInfoRspBO> pageResult = dictMessageCenterInfoMapper.page(reqBO, page);
        // 获取未读和已读数量
        Map<String, Long> statusCounts = dictMessageCenterInfoMapper.countByStatus();
        // 封装结果
        int pageNo = (int) pageResult.getCurrent();
        int pageSize = (int) pageResult.getSize();
        List<DictMessageCenterInfoRspBO> records = pageResult.getRecords();
        long total = pageResult.getTotal();
        long unreadCount = statusCounts.getOrDefault("unread_count", 0L);
        long readCount = statusCounts.getOrDefault("read_count", 0L);

        MessageTodoListResponse<DictMessageCenterInfoRspBO> response = MessageTodoListResponse.newInstance(pageNo, pageSize, records, total, unreadCount, readCount);
        return response;
    }

    @Override
    public DictMessageCenterInfoRspBO detail(DictMessageCenterInfoDetailReqBO reqBO) {
        DictMessageCenterInfoRspBO rspBO = null;
        if (Objects.nonNull(reqBO.getId())) {
            rspBO = dictMessageCenterInfoMapper.detail(reqBO.getId());
        }
        return rspBO;
    }

}
