package com.tydic.dict.system.repository.po;

import lombok.Data;
import java.io.Serializable;
import java.util.Date;

/**
 * 描述：待办任务信息表
 * 
 * @author zhouyi
 * @date 2024-09-23 16:59
 **/
@Data
public class DictAuditTaskTodoPO implements Serializable {
	private static final long serialVersionUID =  -7230226160901857503L;

	/**
	 * 待办编码（唯一标识）
	 */
	private Long pendingCode;
	/**
	 * 待办人；员工工号
	 */
	private String handler;
	/**
	 * 0：待办类型；1：待阅类型；默认0
	 */
	private Integer pendingType;
	/**
	 * 0：待阅/待办，1：已阅/已办
	 */
	private Integer status;
	/**
	 * 1=公文、2=工单、3=报账、4=合同、5=人力资源、6=市场类项目、7=计划建设、8=采购物流、9=数字化档案 10=集中监控系统 11=会议管理系统 12=纪检监察系统 13=宿务管理系统14=督办管理系统、15=全面预算系统 16=研发管理系统 17=新合同 18=产品管理 19=智慧园区 20=OA法务 21=培训 22=绩效 23=OA需求 24=资产管理系统2
	 */
	private Integer type;
	/**
	 * 待办标题
	 */
	private String title;
	/**
	 * 0：非紧急；1：紧急；默认0
	 */
	private Integer urgent;
	/**
	 * 待办类型名称
	 */
	private String clazz;
	/**
	 * PC端URL地址，待办信息URL-待办查看页面
	 */
	private String pcUrl;
	/**
	 * 移动端Url地址，待办信息URL-待办查看页面
	 */
	private String clientUrl;
	/**
	 * 待办时间
	 */
	private Long startDate;
	/**
	 * 待办处理截止时间
	 */
	private Long endDate;
	/**
	 * 上一待办人；中文名称
	 */
	private String preHandler;
	/**
	 * 文号
	 */
	private String docNum;
	/**
	 * 待办发起人；中文名称
	 */
	private String oraniger;
	/**
	 * 拟稿人；中文名称
	 */
	private String ngPerson;
	/**
	 * 拟稿部门；中文名称
	 */
	private String ngDept;
	/**
	 * 拟稿时间；时间戳
	 */
	private Long ngDate;
	/**
	 * 是否代办
	 */
	private Integer isProxy;
	/**
	 * 被代办人
	 */
	private String proxyUser;
	/**
	 * 待办跳转参数
	 */
	private String rawData;
	/**
	 * 推送类型 0苏研OA 1集团OA 2dict
	 */
	private Integer pushType;
	/**
	 * 待办推送类型 0 新建待办推送 1修改待办推送 2 删除待办推送
	 */
	private Integer auditState;
	/**
	 * 是否完成推送 1完成 0未完成
	 */
	private Integer pushState;
	/**
	 * 推送次数
	 */
	private Integer pushNum;
	/**
	 * 推送失败信息
	 */
	private String pushErrorResult;
	/**
	 * 创建待办表时间
	 */
	private Date createDate;
	private Date createDateStart;
	private Date createDateEnd;
	/**
	 * 更新待办表时间
	 */
	private Date updateDate;
	private Date updateDateStart;
	private Date updateDateEnd;
	/**
	 * 排序
	 */
	private String orderBy;

}
