package com.tydic.dict.system.repository.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class DictAuditTodoPO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 编码
     */
    private String code;

    /**
     * 类型
     */
    private String type;

    /**
     * 名称
     */
    private String name;

    /**
     * 描述
     */
    private String description;

    /**
     * 备注
     */
    private String remark;

    /**
     * 业务id
     */
    private Long businessId;

    /**
     * 办理结果
     */
    private Integer result;

    /**
     * 办理人id
     */
    private Long auditUserId;

    /**
     * 上一审批人
     */
    private Long lastAuditUserId;

    /**
     * 状态 0-待办 1-办结
     */
    private Integer status;

    /**
     * 任务下发时间
     */
    private Date createdTime;

    /**
     * 创建人/发起人
     */
    private String createdBy;

    /**
     * 推送状态
     */
    private Integer pushStatus;

    /**
     * 推送次数
     */
    private Integer pushTimes;

    /**
     * 更新时间
     */
    private Date completionTime;

    /**
     * 更新人
     */
    private String updatedBy;

}
