package com.tydic.dict.system.repository.po;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * DICT数据字典表
 * </p>
 *
 * @author liliang
 * @since 2024-09-12
 */
@Getter
@Setter
@TableName("dict_dictionaries")
public class DictDictionariesPO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 模块名称
     */
    @TableField("module_name")
    private String moduleName;

    /**
     * 目录
     */
    @TableField("dic_dir")
    private String dicDir;

    /**
     * 父级字典key
     */
    @TableField("parent_dic_key")
    private String parentDicKey;

    /**
     * 字典键值
     */
    @TableField("dic_key")
    private String dicKey;

    /**
     * 字典标签
     */
    @TableField("dic_value")
    private String dicValue;

    /**
     * 排序
     */
    @TableField("order")
    private Integer order;

    /**
     * 状态(0:有效 1:失效)
     */
    @TableField("status")
    private Integer status;

    /**
     * 描述
     */
    @TableField("remark")
    private String remark;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private Date createTime;

    public String getParentDicKey() {
        return StringUtils.isBlank(this.parentDicKey) ? "-1" : this.parentDicKey;
    }

}
