package com.tydic.dict.system.repository.po;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
* 枚举配置表
* @TableName dict_enum_config
*/
@Data
@TableName("dict_enum_config")
public class DictEnumConfigPo extends DictBasePO implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
    *  主键
    */
    @NotNull(message="[]不能为空")
    @ApiModelProperty("")
    private Long id;

    /**
    * 枚举键
    */
    @NotBlank(message="[枚举键]不能为空")
    @Size(max= 100,message="编码长度不能超过100")
    @ApiModelProperty("枚举键")
    @Length(max= 100,message="编码长度不能超过100")
    private String enumKey;

    /**
    * 枚举值
    */
    @NotBlank(message="[枚举值]不能为空")
    @Size(max= 100,message="编码长度不能超过100")
    @ApiModelProperty("枚举值")
    @Length(max= 100,message="编码长度不能超过100")
    private String enumValue;

    /**
    * 枚举分组
    */
    @NotBlank(message="[枚举分组]不能为空")
    @Size(max= 50,message="编码长度不能超过50")
    @ApiModelProperty("枚举分组")
    @Length(max= 50,message="编码长度不能超过50")
    private String enumGroup;

    /**
    * 描述信息
    */
    @Size(max= 255,message="编码长度不能超过255")
    @ApiModelProperty("描述信息")
    @Length(max= 255,message="编码长度不能超过255")
    private String description;

    /**
    * 状态：1-启用，0-禁用
    */
    @ApiModelProperty("状态：1-启用，0-禁用")
    private Integer status;

}
