package com.tydic.dict.system.repository.po;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("dict_message_template")
public class DictMessageTemplatePO extends DictBasePO{

    @NotNull(message="[]不能为空")
    @ApiModelProperty("")
    private Long id;

    /**
     * 消息模版名称
     */
    @ApiModelProperty("消息模版名称")
    @ExcelProperty("消息模板名称")
    private String name;

    /**
     * 消息模版标识 不超过20个字符
     */
    @NotBlank(message="[消息模版标识 不超过20个字符]不能为空")
    @Size(max= 20,message="编码长度不能超过20")
    @ApiModelProperty("消息模版标识 不超过20个字符")
    @ExcelProperty("消息模板标识")
    private String code;

    /**
     * 消息类型 WB-文本 TC-弹窗 TS-提示
     */
    @Size(max= 10,message="编码长度不能超过10")
    @ApiModelProperty("消息类型")
    @ExcelProperty("消息类型")
    private String type;

    /**
     * 消息场景 00-无 01-成功 02-消息 03-警告 04-错误
     */
    @ApiModelProperty("消息场景 00-无 01-成功 02-消息 03-警告 04-错误")
    @ExcelProperty("消息场景")
    private String scene;

    /**
     * 消息标题 默认继承消息名称
     */
    @NotBlank(message="[消息标题 默认继承消息名称]不能为空")
    @Size(max= 20,message="编码长度不能超过20")
    @ApiModelProperty("消息标题 默认继承消息名称")
    @ExcelProperty("消息标题")
    private String title;

    /**
     * 模版内容 长度最大500
     */
    @NotBlank(message="[模版内容 长度最大500]不能为空")
    @Size(max= 500,message="编码长度不能超过500")
    @ApiModelProperty("模版内容 长度最大500")
    @ExcelProperty("模版内容")
    private String content;

    /**
     * 模版描述 选填 长度最大200
     */
    @Size(max= 200,message="编码长度不能超过200")
    @ApiModelProperty("模版描述 选填 长度最大200")
    @ExcelProperty("模版描述")
    private String description;
}
