/**
 * @(#)DictWarningMsgPO.java Created by wyp on 2024/9/8   18:36
 * <p>
 * Copyrights (C) 2024保留所有权利
 */

package com.tydic.dict.system.repository.po;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * (类型功能说明描述)
 *
 * <p>
 * 修改历史:                                 <br>
 * 修改日期           修改人员       版本       修改内容<br>
 * -------------------------------------------------<br>
 * 2024/9/8 18:36   wyp     1.0       初始化创建<br>
 * </p>
 *
 * @author wyp
 * @version 1.0
 * @since JDK1.8
 */
@Data
@TableName(value = "dict_warning_msg")
public class DictWarningMsgPO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 模块名称
     */
    @TableField("module_name")
    private String moduleName;

    /**
     * 业务编号
     */
    @TableField("business_id")
    private Long businessId;

    /**
     * 预警编号  省代码（2位数字，如江苏32）+系统日期（8位数字，日期格式：YYYYMMDD）+序列号（4位数字，0001-9999，每天从0001开始）
     */
    @TableField("warning_no")
    private String warningNo;

    /**
     * 预警类型
     */
    @TableField("warning_type")
    private String warningType;

    /**
     * 预警标题
     */
    @TableField("warning_title")
    private String warningTitle;

    /**
     * 预警内容
     */
    @TableField("warning_content")
    private String warningContent;

    /**
     * 预警接收人工号
     */
    @TableField("receiver_user_id")
    private Long receiverUserId;

    /**
     * 是否删除，默认0：未删除，1：已删除
     */
    @TableField("deleted")
    private Integer deleted;

    /**
     * 创建时间
     */
    @TableField("created_time")
    private Date createdTime;

    /**
     * 创建人
     */
    @TableField("created_by")
    private String createdBy;

    /**
     * 创建人
     */
    @TableField("updated_time")
    private Date updatedTime;

    /**
     * 更新人
     */
    @TableField("updated_by")
    private String updatedBy;

}
