package com.tydic.dict.system.repository.rsp;

import com.ohaotian.authority.common.rsp.DictPage;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

@Setter
@Getter
public class AuditTodoListResponse <T>{
	private int pageNo;
	private int pageSize;
	private long total;
	private List<T> rows;
	private long todoCount; // 待办数量
	private long doneCount; // 已办数量

	public static <T> AuditTodoListResponse<T> newInstance(int pageNo, int pageSize, List<T> records, long total, long todoCount, long doneCount) {
		AuditTodoListResponse<T> page = new AuditTodoListResponse<>();
		page.setPageNo(pageNo);
		page.setPageSize(pageSize);
		page.setTotal(total);
		page.setRows(records);
		page.setTodoCount(todoCount);
		page.setDoneCount(doneCount);
		return page;
	}
	public static <T> AuditTodoListResponse<T> fromDictPage(DictPage<T> dictPage, long todoCount, long doneCount) {
		AuditTodoListResponse<T> page = new AuditTodoListResponse<>();
		page.setPageNo(dictPage.getPageNo());
		page.setPageSize(dictPage.getPageSize());
		page.setTotal(dictPage.getTotal());
		page.setRows(dictPage.getRows());
		page.setTodoCount(todoCount);
		page.setDoneCount(doneCount);
		return page;
	}
}
