package com.tydic.dict.system.repository.rsp;

import com.ohaotian.authority.common.rsp.DictPage;
import lombok.Getter;
import lombok.Setter;


import java.util.List;

@Setter
@Getter
public class MessageTodoListResponse<T> {
	private int pageNo;
	private int pageSize;
	private long total;
	private List<T> rows;
	private long unreadCount; // 未读数量
	private long readCount; // 已读数量

	public static <T> MessageTodoListResponse<T> newInstance(int pageNo, int pageSize, List<T> records, long total, long unreadCount, long readCount) {
		MessageTodoListResponse<T> page = new MessageTodoListResponse<>();
		page.setPageNo(pageNo);
		page.setPageSize(pageSize);
		page.setTotal(total);
		page.setRows(records);
		page.setUnreadCount(unreadCount);
		page.setReadCount(readCount);
		return page;
	}
	public static <T> MessageTodoListResponse<T> fromDictPage(DictPage<T> dictPage, long unreadCount, long readCount) {
		MessageTodoListResponse<T> page = new MessageTodoListResponse<>();
		page.setPageNo(dictPage.getPageNo());
		page.setPageSize(dictPage.getPageSize());
		page.setTotal(dictPage.getTotal());
		page.setRows(dictPage.getRows());
		page.setUnreadCount(unreadCount);
		page.setReadCount(readCount);
		return page;
	}
}
