package com.tydic.dict.system.repository.service.search;

import com.baomidou.mybatisplus.extension.service.IService;
import com.ohaotian.authority.common.rsp.DictPage;
import com.ohaotian.authority.common.rsp.DictResult;
import com.tydic.dict.system.repository.po.DictMessageTemplatePO;
import com.tydic.dict.system.service.bo.DictMessageTemplateQueryBo;
import com.tydic.dict.system.service.bo.DictMessageTemplateReaderBo;
import com.tydic.dict.system.service.bo.DictMessageTemplateRspBO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

public interface DictMessageTemplateSearchService extends IService<DictMessageTemplatePO> {

    /**
     * 消息模版分页查询
     *
     * @return
     */
    DictResult<DictPage> pageQuery(DictMessageTemplateQueryBo reqBo);

    List<String> getTypeList();

    List<String> getSceneList();

    DictMessageTemplateRspBO render(DictMessageTemplateReaderBo readerBo);

    /**
     * 导出消息模版
     */
    Boolean exportMessageTemplate(HttpServletResponse response);

    /**
     * 下载消息模版
     *
     * @return
     */
    Boolean downloadMessageTemplate(HttpServletResponse response);

    Boolean downloadErrorMessageTemplate(HttpServletResponse response);
}
