package com.tydic.dict.system.repository.service.update;

import com.tydic.dict.system.repository.dao.DictMessageCenterInfoMapper;
import com.tydic.dict.system.repository.po.DictMessageCenterInfoPO;
import com.tydic.dict.system.service.bo.DictCommonDelExportReqBO;
import com.tydic.dict.system.service.bo.DictMessageCenterInfoAddReqBO;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class DictMessageCenterInfoUpdateServiceImpl implements DictMessageCenterInfoUpdateService {

    @Autowired
    private DictMessageCenterInfoMapper dictMessageCenterInfoMapper;

    @Override
    public void add(DictMessageCenterInfoAddReqBO reqBO) {
        if (Objects.isNull(reqBO.getReceiveUserId())) {
            throw new RuntimeException("接收人不能为空");
        }
        DictMessageCenterInfoPO dictMessageCenterInfoPO = new DictMessageCenterInfoPO();
        dictMessageCenterInfoPO.setMessageContent(reqBO.getMessageContent());
        dictMessageCenterInfoPO.setReceiveUserId(reqBO.getReceiveUserId());
        dictMessageCenterInfoPO.setRead(Boolean.FALSE);
        dictMessageCenterInfoPO.setDeleted(Boolean.FALSE);
        dictMessageCenterInfoPO.setCreateTime(new Date());
        dictMessageCenterInfoPO.setUpdateTime(new Date());
        dictMessageCenterInfoPO.setCreateBy("system");
        dictMessageCenterInfoPO.setUpdateBy("system");

        dictMessageCenterInfoMapper.insert(dictMessageCenterInfoPO);

    }

    @Override
    public void batchRead(DictCommonDelExportReqBO reqBO) {
        List<Long> ids = reqBO.getIds();
        if (CollectionUtils.isNotEmpty(ids)) {
            ids = ids.stream().distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(ids)) {
                dictMessageCenterInfoMapper.batchRead(ids);
            }
        }
    }
}
