/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dict.system.repository.impl;

import com.ohaotian.authority.common.rsp.DictResult;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dict.system.repository.dao.DictAuditTaskTodoMapper;
import com.tydic.dict.system.repository.po.DictAuditTaskTodoPO;
import com.tydic.dict.system.repository.service.update.DictAuditTaskTodoBusiService;
import com.tydic.dict.system.service.bo.DictAuditTaskTodoAddReqBO;
import com.tydic.dict.system.service.bo.DictAuditTaskTodoCancelReqBO;
import com.tydic.dict.system.service.bo.DictAuditTaskTodoDelReqBO;
import com.tydic.dict.system.service.bo.DictAuditTaskTodoEditReqBO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class DictAuditTaskTodoBusiServiceImpl
implements DictAuditTaskTodoBusiService {
    private final DictAuditTaskTodoMapper dictAuditTaskTodoMapper;

    public DictAuditTaskTodoBusiServiceImpl(DictAuditTaskTodoMapper dictAuditTaskTodoMapper) {
        this.dictAuditTaskTodoMapper = dictAuditTaskTodoMapper;
    }

    @Override
    public DictResult<String> add(DictAuditTaskTodoAddReqBO reqBO) {
        this.validateAdd(reqBO);
        DictAuditTaskTodoPO dictAuditTaskTodoPO = new DictAuditTaskTodoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)dictAuditTaskTodoPO);
        dictAuditTaskTodoPO.setStatus(0);
        if (dictAuditTaskTodoPO.getUrgent() == null) {
            dictAuditTaskTodoPO.setUrgent(0);
        }
        dictAuditTaskTodoPO.setPushState(0);
        dictAuditTaskTodoPO.setPushNum(0);
        dictAuditTaskTodoPO.setAuditState(0);
        int insert = this.dictAuditTaskTodoMapper.insert(dictAuditTaskTodoPO);
        if (insert < 1) {
            return DictResult.error((Object)"\u6dfb\u52a0\u5f85\u529e\u5931\u8d25", (String)"error");
        }
        return DictResult.success((Object)"\u6dfb\u52a0\u5f85\u529e\u6210\u529f");
    }

    @Override
    public DictResult<String> edit(DictAuditTaskTodoEditReqBO reqBO) {
        if (reqBO.getPendingCode() == null || reqBO.getStatus() == null) {
            throw new ZTBusinessException("\u5f85\u529e\u7f16\u7801\u53ca\u5f85\u529e\u72b6\u6001\u4e0d\u53ef\u4e3a\u7a7a");
        }
        DictAuditTaskTodoPO set = new DictAuditTaskTodoPO();
        DictAuditTaskTodoPO where = new DictAuditTaskTodoPO();
        if (reqBO.getPendingCode() != null && reqBO.getPendingCode() != 0L) {
            where.setPendingCode(reqBO.getPendingCode());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getBusinessCode()})) {
            where.setBusinessCode(reqBO.getBusinessCode());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getTaskId()})) {
            where.setTaskId(reqBO.getTaskId());
        }
        set.setStatus(reqBO.getStatus());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getTitle()})) {
            set.setTitle(reqBO.getTitle());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getPcUrl()})) {
            set.setPcUrl(reqBO.getPcUrl());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getClientUrl()})) {
            set.setClientUrl(reqBO.getClientUrl());
        }
        set.setAuditState(1);
        set.setPushState(0);
        set.setPushNum(0);
        int i = this.dictAuditTaskTodoMapper.updateBy(set, where);
        if (i < 1) {
            return DictResult.error((Object)"\u5220\u9664\u5f85\u529e\u5931\u8d25", (String)"error");
        }
        return DictResult.success((Object)"\u5220\u9664\u5f85\u529e\u6210\u529f");
    }

    @Override
    public DictResult<String> delete(DictAuditTaskTodoDelReqBO reqBO) {
        if (reqBO.getPendingCode() == null) {
            throw new ZTBusinessException("\u5f85\u529e\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        }
        DictAuditTaskTodoPO set = new DictAuditTaskTodoPO();
        DictAuditTaskTodoPO where = new DictAuditTaskTodoPO();
        if (reqBO.getPendingCode() != null && reqBO.getPendingCode() != 0L) {
            where.setPendingCode(reqBO.getPendingCode());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getBusinessCode()})) {
            where.setBusinessCode(reqBO.getBusinessCode());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getTaskId()})) {
            where.setTaskId(reqBO.getTaskId());
        }
        set.setAuditState(2);
        set.setPushState(0);
        set.setPushNum(0);
        int i = this.dictAuditTaskTodoMapper.updateBy(set, where);
        if (i < 1) {
            return DictResult.error((Object)"\u5220\u9664\u5f85\u529e\u5931\u8d25", (String)"error");
        }
        return DictResult.success((Object)"\u5220\u9664\u5f85\u529e\u6210\u529f");
    }

    @Override
    public DictResult<String> editCancel(DictAuditTaskTodoCancelReqBO reqBO) {
        int i = this.dictAuditTaskTodoMapper.editCancelBy(reqBO);
        if (i < 1) {
            return DictResult.error((Object)"\u4fee\u6539\u5f85\u529e\u4f5c\u5e9f\u72b6\u6001\u5931\u8d25", (String)"error");
        }
        return DictResult.success((Object)"\u4fee\u6539\u5f85\u529e\u4f5c\u5e9f\u72b6\u6001\u6210\u529f");
    }

    private void validateAdd(DictAuditTaskTodoAddReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getHandler())) {
            throw new ZTBusinessException("\u5165\u53c2\u5f85\u529e\u4eba\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (reqBO.getPendingType() == null) {
            throw new ZTBusinessException("\u5f85\u529e\u5f85\u9605\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (reqBO.getType() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5f85\u529e\u6765\u6e90\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (reqBO.getTitle() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5f85\u529e\u6807\u9898\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (reqBO.getClazz() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5f85\u529e\u7c7b\u578b\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (reqBO.getPcUrl() == null) {
            throw new ZTBusinessException("\u5165\u53c2pc\u8bbf\u95ee\u8def\u5f84\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (reqBO.getPushType() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u63a8\u9001\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        }
    }
}

