package com.tydic.dict.system.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dict.system.repository.po.SysOperLogPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：操作日志记录
 * 
 * @author zhouyi
 * @date 2024-09-06 21:36
 **/
@Mapper
@Repository
public interface SysOperLogMapper {

	/**
	 * 插入单条数据
	 *
	 * @param sysOperLogPo 参数对象
	 * @return int 影响数量
	 */
	int insert(SysOperLogPO sysOperLogPo);

	/**
	 * 根据条件删除数据
	 *
	 * @param sysOperLogPo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(SysOperLogPO sysOperLogPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param sysOperLogPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(SysOperLogPO sysOperLogPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") SysOperLogPO set, @Param("where") SysOperLogPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param sysOperLogPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(SysOperLogPO sysOperLogPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param sysOperLogPo 参数对象
	 * @return SysOperLogPO 结果对象
	 */
	SysOperLogPO getModelBy(SysOperLogPO sysOperLogPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param sysOperLogPo 参数对象
	 * @return List<SysOperLogPO> 结果对象
	 */
	List<SysOperLogPO> getList(SysOperLogPO sysOperLogPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param sysOperLogPo 参数对象
	 * @param page 分页参数
	 * @return List<SysOperLogPO> 结果对象
	 */
	List<SysOperLogPO> getListPage(SysOperLogPO sysOperLogPo, Page<SysOperLogPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<SysOperLogPO> list);

}
