package com.tydic.dict.system.repository.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ohaotian.authority.common.rsp.DictPage;
import com.ohaotian.authority.common.rsp.DictResult;
import com.tydic.dict.system.repository.dao.DictAnnouncementMapper;
import com.tydic.dict.system.repository.po.DictAnnouncementPo;
import com.tydic.dict.system.repository.service.search.DictAnnouncementSearchService;
import com.tydic.dict.system.service.bo.DictAnnouncementPageReqBo;
import com.tydic.dict.system.service.bo.DictAnnouncementRspBo;
import com.tydic.dict.system.service.constants.HomeConstant;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class DictAnnouncementSearchServiceImpl extends ServiceImpl<DictAnnouncementMapper, DictAnnouncementPo> implements DictAnnouncementSearchService {

    @Autowired
    private DictAnnouncementMapper dictAnnouncementMapper;

    @Override
    public DictAnnouncementRspBo detail(Long id) {
        if (id == null) {
            return null;
        }
        DictAnnouncementPo po = dictAnnouncementMapper.selectById(id);
        if (po == null) {
            return null;
        }
        return BeanUtil.copyProperties(po, DictAnnouncementRspBo.class);
    }

    @Override
    public DictPage<DictAnnouncementRspBo> queryByCondition(DictAnnouncementPageReqBo req) {
        if (StringUtils.isNotBlank(req.getTitle())) {
            req.setTitle("%" + req.getTitle() + "%");
        }
        Page<DictAnnouncementRspBo> dictAnnouncementRspBoPage = dictAnnouncementMapper.selectAnnouncementPage(req, new Page<>(req.getPageNo(), req.getPageSize()));
        return DictPage.newInstance(req.getPageNo(), req.getPageSize(), dictAnnouncementRspBoPage.getRecords(), dictAnnouncementRspBoPage.getTotal());
    }

    @Override
    public List<DictAnnouncementRspBo> selectList() {
        return dictAnnouncementMapper.selectAnnouncementList(HomeConstant.ANNOUNCEMENT_STATUS_PUBLISHED);
    }


    @Override
    public DictPage<DictAnnouncementRspBo> queryAnnouncementPage(DictAnnouncementPageReqBo req) {
        if (StringUtils.isNotBlank(req.getTitle())) {
            req.setTitle("%" + req.getTitle() + "%");
        }
        // 查询已发布的 (用户从首页点进公告列表)
        req.setStatus(HomeConstant.ANNOUNCEMENT_STATUS_PUBLISHED);
        Page<DictAnnouncementRspBo> dictAnnouncementRspBoPage = dictAnnouncementMapper.selectAnnouncementPage(req, new Page<>(req.getPageNo(), req.getPageSize()));
        return DictPage.newInstance(req.getPageNo(), req.getPageSize(), dictAnnouncementRspBoPage.getRecords(), dictAnnouncementRspBoPage.getTotal());
    }
}
