package com.tydic.dict.system.repository.po;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import javax.validation.constraints.NotNull;

import java.io.Serializable;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

/**
 * 公告表
 *
 * @TableName dict_announcement
 */
@TableName("dict_announcement")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DictAnnouncementPo extends DictBasePO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     *
     */
    @NotNull(message = "[]不能为空")
    @ApiModelProperty("")
    private Long id;
    /**
     * 公告标题
     */
    @NotBlank(message = "[公告标题]不能为空")
    @Size(max = 100, message = "编码长度不能超过100")
    @ApiModelProperty("公告标题")
    @Length(max = 100, message = "编码长度不能超过100")
    private String title;
    /**
     * 公告内容
     */
    @NotBlank(message = "[公告内容]不能为空")
    @Size(max = -1, message = "编码长度不能超过-1")
    @ApiModelProperty("公告内容")
    @Length(max = -1, message = "编码长度不能超过-1")
    private String content;
    /**
     * 公告类型（0: 系统公告, 1: 业务公告）
     */
    @NotNull(message = "[公告类型（0: 系统公告, 1: 业务公告）]不能为空")
    @ApiModelProperty("公告类型（0: 系统公告, 1: 业务公告）")
    private Integer type;
    /**
     * 是否置顶（0: 不置顶, 1: 置顶）
     */
    @NotNull(message = "[是否置顶（0: 不置顶, 1: 置顶）]不能为空")
    @ApiModelProperty("是否置顶（0: 不置顶, 1: 置顶）")
    private Integer top;
    /**
     * 附件信息
     */
    @Size(max = 255, message = "编码长度不能超过255")
    @ApiModelProperty("附件信息")
    @Length(max = 255, message = "编码长度不能超过255")
    private String attachments;
    /**
     * 图片信息
     */
    @Size(max = 255, message = "编码长度不能超过255")
    @ApiModelProperty("图片信息")
    @Length(max = 255, message = "编码长度不能超过255")
    private String images;
    /**
     * 公告状态（0: 草稿, 1: 待发布, 2: 已发布）
     */
    @NotNull(message = "[公告状态（0: 草稿, 1: 待发布, 2: 已发布）]不能为空")
    @ApiModelProperty("公告状态（0: 草稿, 1: 待发布, 2: 已发布）")
    private Integer status;
    /**
     * 公告发布时间
     */
    @ApiModelProperty("公告发布时间")
    private Date publishTime;
    /**
     * 公告置顶生效时间
     */
    @ApiModelProperty("公告置顶生效时间")
    private Date startTime;
    /**
     * 公告置顶失效时间
     */
    @ApiModelProperty("公告置顶失效时间")
    private Date endTime;
}
