package com.tydic.dict.system.repository.po;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
* 首页快捷入口表
* @TableName dict_home_menu_quick_entry
*/
@TableName("dict_home_menu_quick_entry")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DictHomeMenuQuickEntryPo extends DictBasePO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
    * 
    */
    @NotNull(message="[]不能为空")
    @ApiModelProperty("")
    private Long id;
    /**
    * 菜单名称
    */
    @NotBlank(message="[菜单名称]不能为空")
    @Size(max= 100,message="编码长度不能超过100")
    @ApiModelProperty("菜单名称")
    @Length(max= 100,message="编码长度不能超过100")
    private String name;
    /**
    * 图标
    */
    @NotBlank(message="[图标]不能为空")
    @Size(max= 255,message="编码长度不能超过255")
    @ApiModelProperty("图标")
    @Length(max= 255,message="编码长度不能超过255")
    private String icon;
    /**
    * 菜单id
    */
    @NotNull(message="[菜单id]不能为空")
    @ApiModelProperty("菜单id")
    private Long menuId;
    /**
    * 排序
    */
    @NotNull(message="[排序]不能为空")
    @ApiModelProperty("排序")
    private Integer sort;
    /**
    * 是否可见（0: 不可见, 1: 可见）
    */
    @NotNull(message="[是否可见（0: 不可见, 1: 可见）]不能为空")
    @ApiModelProperty("是否可见（0: 不可见, 1: 可见）")
    private Integer visible;

}
