package com.tydic.dict.system.repository.util;

import com.tydic.dict.system.repository.po.DictMessageTemplatePO;
import org.apache.commons.lang3.StringUtils;

/**
 * 校验excel上传数据是否规范
 */
public class ValidationUtil {
    public static String validateDictMessageTemplate(DictMessageTemplatePO item) {
        StringBuffer errors = new StringBuffer();
        // 检查name字段
        if (StringUtils.isBlank(item.getName()) || item.getCode().length() > 20) {
            errors.append("消息模版名称不能为空且长度不能超过20个字符");
        }

        // 检查code字段
        if (StringUtils.isBlank(item.getCode()) || item.getCode().length() > 20) {
            errors.append("消息模版标识不能为空且长度不能超过20个字符");
        }

        // 检查type字段
        if (StringUtils.isBlank(item.getType()) ||
                item.getType().length() > 10 ||
                !(item.getType().equals("WB") || item.getType().equals("TC") || item.getType().equals("TS"))
        ) {
            errors.append("消息类型不能为空且长度不能超过10个字符且必须是WB、TC、TS");
        }

        // 检查scene字段
        if (StringUtils.isBlank(item.getScene()) ||
                item.getScene().length() > 10 ||
                !(item.getScene().equals("00") || item.getScene().equals("01") || item.getScene().equals("02") || item.getScene().equals("03") || item.getScene().equals("04"))
        ) {
            errors.append("消息场景不能为空且长度不能超过10个字符且必须是00、01、02、03、04");
        }

        // 检查title字段
        if (StringUtils.isBlank(item.getTitle()) || item.getTitle().length() > 20) {
            errors.append("消息标题不能为空且长度不能超过20个字符");
        }

        // 检查content字段
        if (StringUtils.isBlank(item.getContent()) || item.getContent().length() > 500) {
            errors.append("消息内容不能为空且长度不能超过500个字符");
        }

        // 检查description字段
        if (item.getDescription().length() > 200) {
            errors.append("消息描述不能超过200个字符");
        }

        return errors.toString();
    }
}
