/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dict.system.repository.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ohaotian.authority.common.rsp.DictResult;
import com.tydic.dict.system.repository.dao.DictAnnouncementMapper;
import com.tydic.dict.system.repository.po.DictAnnouncementPo;
import com.tydic.dict.system.repository.po.DictBasePO;
import com.tydic.dict.system.repository.service.update.DictAnnouncementUpdateService;
import com.tydic.dict.system.service.bo.DictAnnouncementDataReqBO;
import com.tydic.dict.system.service.bo.DictAnnouncementReqBo;
import com.tydic.dict.system.service.bo.DictAnnouncementUpdateTopStatusReqBO;
import com.tydic.dict.system.service.constants.HomeConstant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictAnnouncementUpdateServiceImpl
extends ServiceImpl<DictAnnouncementMapper, DictAnnouncementPo>
implements DictAnnouncementUpdateService {
    @Autowired
    private DictAnnouncementMapper dictAnnouncementMapper;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    @Override
    public DictResult<String> add(DictAnnouncementReqBo req) {
        if (req == null) {
            return DictResult.error(null, (String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        DictAnnouncementPo po = (DictAnnouncementPo)BeanUtil.copyProperties((Object)req, DictAnnouncementPo.class);
        po.setCreatedBy(req.getUserId());
        po.setUpdatedBy(req.getUserId());
        po.setCreatedTime(new Date());
        int result = this.dictAnnouncementMapper.insert(po);
        if (result > 0) {
            return DictResult.success((Object)"\u6dfb\u52a0\u6210\u529f");
        }
        return DictResult.error(null, (String)"\u6dfb\u52a0\u5931\u8d25");
    }

    @Override
    public DictResult<String> delete(DictAnnouncementDataReqBO req) {
        if (req == null || req.getId() == null) {
            return DictResult.error(null, (String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        int result = this.dictAnnouncementMapper.deleteById(req.getId());
        if (result > 0) {
            return DictResult.success((Object)"\u5220\u9664\u6210\u529f");
        }
        return DictResult.error(null, (String)"\u5220\u9664\u5931\u8d25");
    }

    @Override
    public DictResult<String> change(DictAnnouncementReqBo req) {
        if (req == null) {
            return DictResult.error(null, (String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        if (req.getStatus().equals(HomeConstant.ANNOUNCEMENT_STATUS_PUBLISHED)) {
            return DictResult.error(null, (String)"\u65e0\u6cd5\u4fee\u6539\u5df2\u53d1\u5e03\u516c\u544a");
        }
        DictAnnouncementPo po = new DictAnnouncementPo();
        BeanUtil.copyProperties((Object)req, (Object)po);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.lambda().eq(DictAnnouncementPo::getId, (Object)po.getId());
        updateWrapper.lambda().set(DictAnnouncementPo::getTitle, (Object)po.getTitle());
        updateWrapper.lambda().set(DictAnnouncementPo::getContent, (Object)po.getContent());
        updateWrapper.lambda().set(DictAnnouncementPo::getType, (Object)po.getType());
        updateWrapper.lambda().set(DictAnnouncementPo::getTop, (Object)po.getTop());
        updateWrapper.lambda().set(DictAnnouncementPo::getAttachments, (Object)po.getAttachments());
        updateWrapper.lambda().set(DictAnnouncementPo::getImages, (Object)po.getImages());
        updateWrapper.lambda().set(DictAnnouncementPo::getStatus, (Object)po.getStatus());
        updateWrapper.lambda().set(DictAnnouncementPo::getPublishTime, (Object)po.getPublishTime());
        updateWrapper.lambda().set(DictAnnouncementPo::getStartTime, (Object)po.getStartTime());
        updateWrapper.lambda().set(DictAnnouncementPo::getEndTime, (Object)po.getEndTime());
        updateWrapper.lambda().set(DictBasePO::getUpdatedTime, (Object)new Date());
        int result = this.dictAnnouncementMapper.update(po, (Wrapper)updateWrapper);
        if (result > 0) {
            return DictResult.success((Object)"\u4fee\u6539\u6210\u529f");
        }
        return DictResult.error(null, (String)"\u4fee\u6539\u5931\u8d25");
    }

    @Override
    public DictResult<String> updateStatus(DictAnnouncementReqBo req) {
        if (req == null) {
            return DictResult.error(null, (String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        DictAnnouncementPo po = (DictAnnouncementPo)this.dictAnnouncementMapper.selectById(req.getId());
        if (po == null) {
            return DictResult.error(null, (String)"\u67e5\u8be2\u5931\u8d25");
        }
        po.setUpdatedBy(req.getUserId());
        po.setUpdatedTime(new Date());
        po.setStatus(req.getStatus());
        if (po.getStatus().equals(HomeConstant.ANNOUNCEMENT_STATUS_DRAFT)) {
            return DictResult.error(null, (String)"\u65e0\u6cd5\u4fee\u6539\u8349\u7a3f\u72b6\u6001");
        }
        if (req.getStatus().equals(HomeConstant.ANNOUNCEMENT_STATUS_PUBLISHED)) {
            po.setPublishTime(new Date());
            int result = this.dictAnnouncementMapper.updateById(po);
            if (result > 0) {
                return DictResult.success((Object)"\u53d1\u5e03\u6210\u529f");
            }
            return DictResult.success((Object)"\u53d1\u5e03\u5931\u8d25");
        }
        if (req.getStatus().equals(HomeConstant.ANNOUNCEMENT_STATUS_NO_PUBLISH)) {
            int result = this.dictAnnouncementMapper.update(po, (Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(DictAnnouncementPo::getId, (Object)po.getId())).set(DictAnnouncementPo::getPublishTime, null));
            if (result > 0) {
                return DictResult.success((Object)"\u53d6\u6d88\u53d1\u5e03\u6210\u529f");
            }
            return DictResult.success((Object)"\u53d6\u6d88\u53d1\u5e03\u5931\u8d25");
        }
        return DictResult.error(null, (String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @Override
    public DictResult<String> updateTop(DictAnnouncementReqBo req) {
        if (req == null) {
            return DictResult.error(null, (String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        DictAnnouncementPo po = (DictAnnouncementPo)this.dictAnnouncementMapper.selectById(req.getId());
        if (po == null) {
            return DictResult.error(null, (String)"\u67e5\u8be2\u5931\u8d25");
        }
        if (po.getStatus().equals(HomeConstant.ANNOUNCEMENT_STATUS_PUBLISHED)) {
            po.setUpdatedBy(req.getUserId());
            po.setUpdatedTime(new Date());
            po.setTop(req.getTop());
            if (req.getTop().equals(HomeConstant.ANNOUNCEMENT_TOP)) {
                if (req.getStartTime() != null && !req.getStartTime().before(new Date())) {
                    po.setStartTime(this.truncateToMinutes(req.getStartTime()));
                } else {
                    po.setStartTime(this.truncateToMinutes(new Date()));
                }
                if (req.getEndTime() != null) {
                    po.setEndTime(this.truncateToMinutes(req.getEndTime()));
                } else {
                    LocalDateTime now = LocalDateTime.now();
                    LocalDateTime threeDaysLater = now.plusDays(3L);
                    po.setEndTime(Date.from(threeDaysLater.atZone(ZoneId.systemDefault()).toInstant()));
                }
                int result = this.dictAnnouncementMapper.updateById(po);
                if (result > 0) {
                    return DictResult.success((Object)"\u7f6e\u9876\u6210\u529f");
                }
                return DictResult.error(null, (String)"\u7f6e\u9876\u5931\u8d25");
            }
            if (req.getTop().equals(HomeConstant.ANNOUNCEMENT_NO_TOP)) {
                int result = this.dictAnnouncementMapper.update(po, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(DictAnnouncementPo::getId, (Object)po.getId())).set(DictAnnouncementPo::getStartTime, null)).set(DictAnnouncementPo::getEndTime, null));
                if (result > 0) {
                    return DictResult.success((Object)"\u53d6\u6d88\u7f6e\u9876\u6210\u529f");
                }
                return DictResult.error(null, (String)"\u53d6\u6d88\u7f6e\u9876\u5931\u8d25");
            }
        } else {
            return DictResult.error(null, (String)"\u65e0\u6cd5\u7f6e\u9876\u975e\u5df2\u53d1\u5e03\u516c\u544a");
        }
        return DictResult.error(null, (String)"\u7f6e\u9876\u5931\u8d25");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchUpdateStatus(List<DictAnnouncementUpdateTopStatusReqBO> updateList) {
        if (CollectionUtils.isNotEmpty(updateList) && CollectionUtils.isNotEmpty(updateList = updateList.stream().filter(update -> Objects.nonNull(update.getId()) && Objects.nonNull(update.getTopStatus())).collect(Collectors.toList()))) {
            try (SqlSession sqlSession = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);){
                DictAnnouncementMapper announcementMapper = (DictAnnouncementMapper)sqlSession.getMapper(DictAnnouncementMapper.class);
                updateList.forEach(announcementMapper::updateTop);
                sqlSession.commit();
            }
        }
    }

    private Date truncateToMinutes(Date date) {
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        localDateTime = localDateTime.withSecond(0).withNano(0);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }
}

