/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dict.system.repository.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.authority.common.rsp.DictResult;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dict.system.repository.dao.DictAuditTaskTodoMapper;
import com.tydic.dict.system.repository.rsp.AuditTodoListResponse;
import com.tydic.dict.system.repository.service.search.DictAuditTodoSearchService;
import com.tydic.dict.system.service.bo.DictAuditTaskTodoCancelReqBO;
import com.tydic.dict.system.service.bo.DictAuditTodoQryDetailReqBO;
import com.tydic.dict.system.service.bo.DictAuditTodoQryReqBO;
import com.tydic.dict.system.service.bo.DictAuditTodoRspBO;
import com.tydic.dict.system.service.common.DictAuditTodoTypeEnum;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictAuditTodoSearchServiceImpl
implements DictAuditTodoSearchService {
    @Autowired
    private DictAuditTaskTodoMapper dictAuditTaskTodoMapper;

    @Override
    public AuditTodoListResponse<DictAuditTodoRspBO> list(DictAuditTodoQryReqBO bo) {
        Page page = new Page((long)bo.getPageNo(), (long)bo.getPageSize());
        String orderBy = Objects.isNull(bo.getStatus()) || bo.getStatus() == false ? "create_date" : "update_date";
        Page<DictAuditTodoRspBO> pageResult = this.dictAuditTaskTodoMapper.page(bo, orderBy, (Page<DictAuditTodoRspBO>)page);
        if (CollectionUtils.isNotEmpty((Collection)pageResult.getRecords())) {
            pageResult.getRecords().forEach(rspBO -> rspBO.setType(DictAuditTodoTypeEnum.getDesByCode((String)rspBO.getType())));
        }
        Map<String, Long> statusCounts = this.dictAuditTaskTodoMapper.countByStatus(bo.getUserId());
        int pageNo = (int)pageResult.getCurrent();
        int pageSize = (int)pageResult.getSize();
        List records = pageResult.getRecords();
        long total = pageResult.getTotal();
        long todoCount = statusCounts.getOrDefault("todo_count", 0L);
        long doneCount = statusCounts.getOrDefault("done_count", 0L);
        long toBeReadCount = statusCounts.getOrDefault("to_be_read_count", 0L);
        long readCount = statusCounts.getOrDefault("read_count", 0L);
        AuditTodoListResponse<DictAuditTodoRspBO> response = AuditTodoListResponse.newInstance(pageNo, pageSize, records, total, todoCount, doneCount, toBeReadCount, readCount);
        return response;
    }

    @Override
    public DictAuditTodoRspBO detail(DictAuditTodoQryDetailReqBO reqBO) {
        DictAuditTodoRspBO dictAuditTodoRspBO = this.dictAuditTaskTodoMapper.selectByPendingCode(Long.valueOf(reqBO.getPendingCode()));
        if (Objects.nonNull(dictAuditTodoRspBO)) {
            dictAuditTodoRspBO.setType(DictAuditTodoTypeEnum.getDesByCode((String)dictAuditTodoRspBO.getType()));
        }
        return dictAuditTodoRspBO;
    }

    @Override
    public DictResult<List<String>> cancelTradeIdList(DictAuditTaskTodoCancelReqBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getBusinessCode())) {
            throw new ZTBusinessException("\u5546\u673a\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (reqBO.getIsCancel() == null) {
            throw new ZTBusinessException("\u662f\u5426\u4f5c\u5e9f\u4e0d\u53ef\u4e3a\u7a7a");
        }
        return DictResult.success(this.dictAuditTaskTodoMapper.selectTradeIdBy(reqBO));
    }

    @Override
    public DictAuditTodoRspBO detailByTaskId(DictAuditTodoQryDetailReqBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getTaskId())) {
            throw new ZTBusinessException("taskId\u4e0d\u53ef\u4e3a\u7a7a");
        }
        return this.dictAuditTaskTodoMapper.selectByTaskId(reqBO.getTaskId());
    }
}

