/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dict.system.repository.impl;

import com.google.common.collect.Maps;
import com.tydic.dict.system.repository.dao.DictDictionariesMapper;
import com.tydic.dict.system.repository.po.DictDictionariesPO;
import com.tydic.dict.system.repository.service.search.DictDictionarySearchService;
import com.tydic.dict.system.service.bo.DictDictionaryBatchQryByDicKeyReqBO;
import com.tydic.dict.system.service.bo.DictDictionaryQryByDicKeyReqBO;
import com.tydic.dict.system.service.bo.DictDictionaryQryByModuNameAndDicDirReqBO;
import com.tydic.dict.system.service.bo.DictDictionaryRspBO;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class DictDictionarySearchServiceImpl
implements DictDictionarySearchService {
    @Autowired
    private DictDictionariesMapper dictDictionariesMapper;
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public List<DictDictionaryRspBO> searchByModuleNameAndDicDir(DictDictionaryQryByModuNameAndDicDirReqBO reqBO) {
        List<DictDictionariesPO> dictDictionariesPOS;
        List result = null;
        if (Objects.nonNull(reqBO) && CollectionUtils.isNotEmpty(dictDictionariesPOS = this.dictDictionariesMapper.selectByModuleNameAndDicDir(reqBO))) {
            Map<String, List> parentDicKeyMap = dictDictionariesPOS.stream().collect(Collectors.groupingBy(DictDictionariesPO::getParentDicKey, Collectors.collectingAndThen(Collectors.toList(), list -> {
                list.sort(Comparator.comparingInt(DictDictionariesPO::getOrder));
                return list;
            })));
            result = parentDicKeyMap.get("-1").stream().map(dictionariesPO -> {
                DictDictionaryRspBO dicRspBO = new DictDictionaryRspBO();
                dicRspBO.setValue(dictionariesPO.getDicKey());
                dicRspBO.setLabel(dictionariesPO.getDicValue());
                dicRspBO.setParentCode(null);
                dicRspBO.setChildren(this.getChildren((List)parentDicKeyMap.get(dictionariesPO.getDicKey()), parentDicKeyMap));
                return dicRspBO;
            }).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public DictDictionaryRspBO searchByDicKey(DictDictionaryQryByDicKeyReqBO reqBO) {
        DictDictionariesPO dictDictionariesPO;
        DictDictionaryRspBO result = null;
        if (Objects.nonNull(reqBO) && com.alibaba.excel.util.StringUtils.isNotBlank((CharSequence)reqBO.getDicKey()) && Objects.nonNull(dictDictionariesPO = this.dictDictionariesMapper.selectByDicKey(reqBO.getDicKey()))) {
            result = new DictDictionaryRspBO();
            result.setValue(dictDictionariesPO.getDicKey());
            result.setLabel(dictDictionariesPO.getDicValue());
            result.setParentCode(null);
        }
        return result;
    }

    @Override
    public Map<String, String> batchSearchByDicKey(DictDictionaryBatchQryByDicKeyReqBO reqBO) {
        List<DictDictionariesPO> dictDictionariesPOList;
        List<String> dicKeys;
        Map<Object, Object> result = Maps.newHashMap();
        if (Objects.nonNull(reqBO) && CollectionUtils.isNotEmpty((Collection)reqBO.getDicKeys()) && CollectionUtils.isNotEmpty(dicKeys = reqBO.getDicKeys().stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList())) && CollectionUtils.isNotEmpty(dictDictionariesPOList = this.dictDictionariesMapper.selectByDicKeys(dicKeys))) {
            result = dictDictionariesPOList.stream().collect(Collectors.toMap(DictDictionariesPO::getDicKey, DictDictionariesPO::getDicValue, (v1, v2) -> v2));
        }
        return result;
    }

    private List<DictDictionaryRspBO> getChildren(List<DictDictionariesPO> dictDictionariesPOS, Map<String, List<DictDictionariesPO>> parentDicKeyMap) {
        List children = null;
        if (CollectionUtils.isNotEmpty(dictDictionariesPOS)) {
            children = dictDictionariesPOS.stream().map(dictionariesPO -> {
                DictDictionaryRspBO dicRspBO = new DictDictionaryRspBO();
                dicRspBO.setValue(dictionariesPO.getDicKey());
                dicRspBO.setLabel(dictionariesPO.getDicValue());
                dicRspBO.setParentCode(dictionariesPO.getParentDicKey());
                dicRspBO.setChildren(this.getChildren((List)parentDicKeyMap.get(dictionariesPO.getDicKey()), parentDicKeyMap));
                return dicRspBO;
            }).collect(Collectors.toList());
        }
        return children;
    }
}

