/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dict.system.repository.task;

import cn.hutool.core.date.DateTime;
import com.tydic.dict.system.repository.service.search.DictAnnouncementSearchService;
import com.tydic.dict.system.repository.service.update.DictAnnouncementUpdateService;
import com.tydic.dict.system.service.bo.DictAnnouncementRspBo;
import com.tydic.dict.system.service.bo.DictAnnouncementUpdateTopStatusReqBO;
import com.tydic.dict.system.service.constants.HomeConstant;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DictAnnouncementTask {
    @Autowired
    private DictAnnouncementSearchService dictAnnouncementSearchService;
    @Autowired
    private DictAnnouncementUpdateService dictAnnouncementUpdateService;

    @XxlJob(value="updateAnnouncementTopStatusTask")
    public void updateAnnouncementTopStatusTask() {
        XxlJobHelper.log((String)"update announcement top status task start....", (Object[])new Object[0]);
        DateTime now = DateTime.now();
        XxlJobHelper.log((String)"get announcement list....", (Object[])new Object[0]);
        List<DictAnnouncementRspBo> dictAnnouncementRspBos = this.dictAnnouncementSearchService.selectList();
        XxlJobHelper.log((String)"get [{}] announcement....", (Object[])new Object[]{dictAnnouncementRspBos.size()});
        if (CollectionUtils.isNotEmpty(dictAnnouncementRspBos)) {
            XxlJobHelper.log((String)"handle announcement top status....", (Object[])new Object[]{dictAnnouncementRspBos.size()});
            List<DictAnnouncementUpdateTopStatusReqBO> updateList = dictAnnouncementRspBos.stream().filter(rspBO -> Objects.nonNull(rspBO.getStartTime()) && Objects.nonNull(rspBO.getEndTime())).map(rspBO -> {
                DictAnnouncementUpdateTopStatusReqBO updateTopStatusReqBO = new DictAnnouncementUpdateTopStatusReqBO();
                updateTopStatusReqBO.setId(rspBO.getId());
                if (now.isAfterOrEquals(rspBO.getStartTime()) && now.isBeforeOrEquals(rspBO.getEndTime())) {
                    updateTopStatusReqBO.setTopStatus(HomeConstant.ANNOUNCEMENT_TOP);
                } else {
                    updateTopStatusReqBO.setTopStatus(HomeConstant.ANNOUNCEMENT_NO_TOP);
                }
                return updateTopStatusReqBO;
            }).collect(Collectors.toList());
            XxlJobHelper.log((String)"need update [{}] announcement top status...", (Object[])new Object[]{updateList.size()});
            this.dictAnnouncementUpdateService.batchUpdateStatus(updateList);
            XxlJobHelper.log((String)"update [{}] announcement top status success...", (Object[])new Object[]{updateList.size()});
        }
        XxlJobHelper.log((String)"update announcement top status task end....\u201c", (Object[])new Object[0]);
    }
}

