package com.tydic.dict.system.repository.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.tydic.dict.system.repository.po.DictDictionariesPO;
import com.tydic.dict.system.service.bo.DictDictionaryQryByModuNameAndDicDirReqBO;
import com.tydic.dict.system.service.bo.DictDictionaryUpdateReqBO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * DICT数据字典表 Mapper 接口
 * </p>
 *
 * @author liliang
 * @since 2024-09-12
 */
@Mapper
public interface DictDictionariesMapper extends BaseMapper<DictDictionariesPO> {

    List<DictDictionariesPO> selectByModuleNameAndDicDir(@Param("reqBO") DictDictionaryQryByModuNameAndDicDirReqBO reqBO);

    @Override
    int insert(DictDictionariesPO dictDictionariesPO);

    DictDictionariesPO selectByDicKey(@Param("dicKey") String dicKey);

    List<DictDictionariesPO> selectByDicKeys(@Param("dicKeys") List<String> dicKeys);

    void updateDic(@Param("reqBO") DictDictionaryUpdateReqBO reqBO);

    void deleteDic(@Param("dicKeys") List<String> dicKeys);
}
