package com.tydic.dict.system.repository.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tydic.dict.system.repository.po.DictMessageCenterInfoPO;
import com.tydic.dict.system.service.bo.DictMessageCenterInfoListReqBO;
import com.tydic.dict.system.service.bo.DictMessageCenterInfoRspBO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 信息中心表 Mapper 接口
 * </p>
 *
 * @author liliang
 * @since 2024-09-15
 */
@Mapper
public interface DictMessageCenterInfoMapper extends BaseMapper<DictMessageCenterInfoPO> {

    @Override
    int insert(DictMessageCenterInfoPO dictMessageCenterInfoPO);

    void batchInsert(@Param("poList") List<DictMessageCenterInfoPO> poList);

    DictMessageCenterInfoRspBO detail(@Param("id") Long id);

    void batchRead(@Param("ids") List<Long> ids);

    Page<DictMessageCenterInfoRspBO> page(@Param("reqBO") DictMessageCenterInfoListReqBO reqBO, Page<DictMessageCenterInfoRspBO> page);

    Map<String, Long> countByStatus(@Param("userId") String userId);

}
