package com.tydic.dict.system.repository.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ohaotian.authority.common.rsp.DictResult;
import com.tydic.dict.system.repository.dao.DictAnnouncementMapper;
import com.tydic.dict.system.repository.po.DictAnnouncementPo;
import com.tydic.dict.system.repository.service.update.DictAnnouncementUpdateService;
import com.tydic.dict.system.service.bo.DictAnnouncementDataReqBO;
import com.tydic.dict.system.service.bo.DictAnnouncementReqBo;
import com.tydic.dict.system.service.bo.DictAnnouncementUpdateTopStatusReqBO;
import com.tydic.dict.system.service.constants.HomeConstant;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class DictAnnouncementUpdateServiceImpl extends ServiceImpl<DictAnnouncementMapper, DictAnnouncementPo> implements DictAnnouncementUpdateService {

    @Autowired
    private DictAnnouncementMapper dictAnnouncementMapper;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    @Override
    public DictResult<String> add(DictAnnouncementReqBo req) {
        if (req == null) {
            return DictResult.error(null, "参数为空");
        }
        DictAnnouncementPo po = BeanUtil.copyProperties(req, DictAnnouncementPo.class);
        po.setCreatedBy(req.getUserId());
        po.setUpdatedBy(req.getUserId());
        po.setCreatedTime(new Date());
        int result = dictAnnouncementMapper.insert(po);
        if (result > 0) {
            return DictResult.success("添加成功");
        }
        return DictResult.error(null, "添加失败");
    }

    @Override
    public DictResult<String> delete(DictAnnouncementDataReqBO req) {
        if (req == null || req.getId() == null) {
            return DictResult.error(null, "参数为空");
        }
        int result = dictAnnouncementMapper.deleteById(req.getId());
        if (result > 0) {
            return DictResult.success("删除成功");
        }
        return DictResult.error(null, "删除失败");
    }

    @Override
    public DictResult<String> change(DictAnnouncementReqBo req) {
        if (req == null) {
            return DictResult.error(null, "参数为空");
        }
        if (req.getStatus().equals(HomeConstant.ANNOUNCEMENT_STATUS_PUBLISHED)) {
            return DictResult.error(null, "无法修改已发布公告");
        }
        DictAnnouncementPo po = new DictAnnouncementPo();
        BeanUtil.copyProperties(req, po);
        UpdateWrapper<DictAnnouncementPo> updateWrapper = new UpdateWrapper<>();
        updateWrapper.lambda().eq(DictAnnouncementPo::getId, po.getId());
        updateWrapper.lambda().set(DictAnnouncementPo::getTitle, po.getTitle());
        updateWrapper.lambda().set(DictAnnouncementPo::getContent, po.getContent());
        updateWrapper.lambda().set(DictAnnouncementPo::getType, po.getType());
        updateWrapper.lambda().set(DictAnnouncementPo::getTop, po.getTop());
        updateWrapper.lambda().set(DictAnnouncementPo::getAttachments, po.getAttachments());
        updateWrapper.lambda().set(DictAnnouncementPo::getImages, po.getImages());
        updateWrapper.lambda().set(DictAnnouncementPo::getStatus, po.getStatus());
        updateWrapper.lambda().set(DictAnnouncementPo::getPublishTime, po.getPublishTime());
        updateWrapper.lambda().set(DictAnnouncementPo::getStartTime, po.getStartTime());
        updateWrapper.lambda().set(DictAnnouncementPo::getEndTime, po.getEndTime());
        updateWrapper.lambda().set(DictAnnouncementPo::getUpdatedTime, new Date());

        int result = dictAnnouncementMapper.update(po, updateWrapper);
//        int result = dictAnnouncementMapper.updateById(po);
        if (result > 0) {
            return DictResult.success("修改成功");
        }
        return DictResult.error(null, "修改失败");
    }

    @Override
    public DictResult<String> updateStatus(DictAnnouncementReqBo req) {
        if (req == null) {
            return DictResult.error(null, "参数为空");
        }
        DictAnnouncementPo po = dictAnnouncementMapper.selectById(req.getId());
        if (po == null) {
            return DictResult.error(null, "查询失败");
        }
        po.setUpdatedBy(req.getUserId());
        po.setUpdatedTime(new Date());
        po.setStatus(req.getStatus());
        if (po.getStatus().equals(HomeConstant.ANNOUNCEMENT_STATUS_DRAFT)) {
            return DictResult.error(null, "无法修改草稿状态");

        } else if (req.getStatus().equals(HomeConstant.ANNOUNCEMENT_STATUS_PUBLISHED)) {
            po.setPublishTime(new Date());
            int result = dictAnnouncementMapper.updateById(po);
            if (result > 0) {
                return DictResult.success("发布成功");
            } else {
                return DictResult.success("发布失败");
            }
        } else if (req.getStatus().equals(HomeConstant.ANNOUNCEMENT_STATUS_NO_PUBLISH)) {
            //po.setPublishTime(null);
            //int result = dictAnnouncementMapper.updateById(po);
            int result = dictAnnouncementMapper.update(po, new UpdateWrapper<DictAnnouncementPo>().lambda()
                    .eq(DictAnnouncementPo::getId, po.getId())
                    .set(DictAnnouncementPo::getPublishTime, null)
            );
            if (result > 0) {
                return DictResult.success("取消发布成功");
            } else {
                return DictResult.success("取消发布失败");
            }
        }
        return DictResult.error(null, "操作失败");
    }

    @Override
    public DictResult<String> updateTop(DictAnnouncementReqBo req) {
        if (req == null) {
            return DictResult.error(null, "参数为空");
        }
        DictAnnouncementPo po = dictAnnouncementMapper.selectById(req.getId());
        if (po == null) {
            return DictResult.error(null, "查询失败");
        }
        if (po.getStatus().equals(HomeConstant.ANNOUNCEMENT_STATUS_PUBLISHED)) {
            po.setUpdatedBy(req.getUserId());
            po.setUpdatedTime(new Date());

            po.setTop(req.getTop());
            if (req.getTop().equals(HomeConstant.ANNOUNCEMENT_TOP)) {
                if (req.getStartTime() != null && !req.getStartTime().before(new Date())) {
                    po.setStartTime(truncateToMinutes(req.getStartTime()));
                } else {
                    po.setStartTime(truncateToMinutes(new Date()));
                }
                if (req.getEndTime() != null) {
                    po.setEndTime(truncateToMinutes(req.getEndTime()));
                } else {
                    LocalDateTime now = LocalDateTime.now();
                    LocalDateTime threeDaysLater = now.plusDays(3);
                    po.setEndTime(Date.from(threeDaysLater.atZone(ZoneId.systemDefault()).toInstant()));
                }
                int result = dictAnnouncementMapper.updateById(po);
                if (result > 0) {
                    return DictResult.success("置顶成功");
                } else {
                    return DictResult.error(null, "置顶失败");
                }
            } else if (req.getTop().equals(HomeConstant.ANNOUNCEMENT_NO_TOP)) {
                int result = dictAnnouncementMapper.update(po, new UpdateWrapper<DictAnnouncementPo>().lambda()
                        .eq(DictAnnouncementPo::getId, po.getId())
                        .set(DictAnnouncementPo::getStartTime, null)
                        .set(DictAnnouncementPo::getEndTime, null)
                );
                if (result > 0) {
                    return DictResult.success("取消置顶成功");
                } else {
                    return DictResult.error(null, "取消置顶失败");
                }
            }
        } else {
            return DictResult.error(null, "无法置顶非已发布公告");
        }
        return DictResult.error(null, "置顶失败");
    }

    @Override
    public void batchUpdateStatus(List<DictAnnouncementUpdateTopStatusReqBO> updateList) {
        if (CollectionUtils.isNotEmpty(updateList)) {
            updateList = updateList.stream().filter(update -> Objects.nonNull(update.getId()) && Objects.nonNull(update.getTopStatus())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(updateList)) {
                SqlSession sqlSession = sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
                try {
                    DictAnnouncementMapper announcementMapper = sqlSession.getMapper(DictAnnouncementMapper.class);
                    updateList.forEach(announcementMapper::updateTop);
                    sqlSession.commit();
                } finally {
                    sqlSession.close();
                }
            }
        }
    }

    private Date truncateToMinutes(Date date) {
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        localDateTime = localDateTime.withSecond(0).withNano(0);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

}
