package com.tydic.dict.system.repository.impl;

import com.ohaotian.authority.common.rsp.DictResult;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dict.system.repository.dao.DictAuditTaskTodoMapper;
import com.tydic.dict.system.repository.po.DictAuditTaskTodoPO;
import com.tydic.dict.system.repository.service.update.DictAuditTaskTodoBusiService;
import com.tydic.dict.system.service.bo.DictAuditTaskTodoAddReqBO;
import com.tydic.dict.system.service.bo.DictAuditTaskTodoCancelReqBO;
import com.tydic.dict.system.service.bo.DictAuditTaskTodoDelReqBO;
import com.tydic.dict.system.service.bo.DictAuditTaskTodoEditReqBO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

/**
 * @author zhouyi
 * @date 2024/9/23
 **/
@Service
public class DictAuditTaskTodoBusiServiceImpl implements DictAuditTaskTodoBusiService {

    private final DictAuditTaskTodoMapper dictAuditTaskTodoMapper;

    public DictAuditTaskTodoBusiServiceImpl(DictAuditTaskTodoMapper dictAuditTaskTodoMapper) {
        this.dictAuditTaskTodoMapper = dictAuditTaskTodoMapper;
    }

    @Override
    public DictResult<String> add(DictAuditTaskTodoAddReqBO reqBO) {
        validateAdd(reqBO);

        DictAuditTaskTodoPO dictAuditTaskTodoPO = new DictAuditTaskTodoPO();
        BeanUtils.copyProperties(reqBO, dictAuditTaskTodoPO);
        dictAuditTaskTodoPO.setStatus(0);
        if(dictAuditTaskTodoPO.getUrgent() == null) {
            dictAuditTaskTodoPO.setUrgent(0);
        }
        dictAuditTaskTodoPO.setPushState(0);
        dictAuditTaskTodoPO.setPushNum(0);
        dictAuditTaskTodoPO.setAuditState(0);
        int insert = dictAuditTaskTodoMapper.insert(dictAuditTaskTodoPO);
        if(insert < 1){
            return DictResult.error("添加待办失败", "error");
        }
        return DictResult.success("添加待办成功");
    }

    @Override
    public DictResult<String> edit(DictAuditTaskTodoEditReqBO reqBO) {
        if(reqBO.getStatus() == null){
            throw new ZTBusinessException("待办状态不可为空");
        }
        DictAuditTaskTodoPO set = new DictAuditTaskTodoPO();
        DictAuditTaskTodoPO where = new DictAuditTaskTodoPO();
        if(reqBO.getPendingCode() != null && reqBO.getPendingCode() != 0) {
            where.setPendingCode(reqBO.getPendingCode());
        }
        if(StringUtils.isNoneBlank(reqBO.getBusinessCode())){
            where.setBusinessCode(reqBO.getBusinessCode());
        }
        if(StringUtils.isNoneBlank(reqBO.getTaskId())){
            where.setTaskId(reqBO.getTaskId());
        }
        set.setStatus(reqBO.getStatus());
        if(StringUtils.isNoneBlank(reqBO.getTitle())) {
            set.setTitle(reqBO.getTitle());
        }
        if(StringUtils.isNoneBlank(reqBO.getPcUrl())) {
            set.setPcUrl(reqBO.getPcUrl());
        }
        if(StringUtils.isNoneBlank(reqBO.getClientUrl())) {
            set.setClientUrl(reqBO.getClientUrl());
        }
        if(StringUtils.isNoneBlank(reqBO.getApproveResult())) {
            set.setApproveResult(reqBO.getApproveResult());
        }
        if(StringUtils.isNoneBlank(reqBO.getApproveAdvice())) {
            set.setApproveAdvice(reqBO.getApproveAdvice());
        }
        set.setAuditState(1);
        set.setPushState(0);
        set.setPushNum(0);
        int i = dictAuditTaskTodoMapper.updateBy(set,where);
        if(i < 1){
            return DictResult.error("更新待办失败", "error");
        }
        return DictResult.success("更新待办成功");
    }

    @Override
    public DictResult<String> delete(DictAuditTaskTodoDelReqBO reqBO) {
        if(reqBO.getPendingCode() == null){
            throw new ZTBusinessException("待办编码不可为空");
        }
        DictAuditTaskTodoPO set = new DictAuditTaskTodoPO();
        DictAuditTaskTodoPO where = new DictAuditTaskTodoPO();
        if(reqBO.getPendingCode() != null && reqBO.getPendingCode() != 0) {
            where.setPendingCode(reqBO.getPendingCode());
        }
        if(StringUtils.isNoneBlank(reqBO.getBusinessCode())){
            where.setBusinessCode(reqBO.getBusinessCode());
        }
        if(StringUtils.isNoneBlank(reqBO.getTaskId())){
            where.setTaskId(reqBO.getTaskId());
        }
        set.setAuditState(2);
        set.setPushState(0);
        set.setPushNum(0);
        int i = dictAuditTaskTodoMapper.updateBy(set,where);
        if(i < 1){
            return DictResult.error("删除待办失败", "error");
        }
        return DictResult.success("删除待办成功");
    }

    @Override
    public DictResult<String> editCancel(DictAuditTaskTodoCancelReqBO reqBO) {
        if(StringUtils.isBlank(reqBO.getBusinessCode())){
            throw new ZTBusinessException("商机编码不可为空");
        }
        if(reqBO.getIsCancel() == null){
            throw new ZTBusinessException("是否作废不可为空");
        }
        int i = dictAuditTaskTodoMapper.editCancelBy(reqBO);
        if(i < 1){
            return DictResult.error("修改待办作废状态失败", "error");
        }
        return DictResult.success("修改待办作废状态成功");
    }

    private void validateAdd(DictAuditTaskTodoAddReqBO reqBO) {
        if(StringUtils.isEmpty(reqBO.getHandler())){
            throw new ZTBusinessException("入参待办人不可为空");
        }
        if(reqBO.getPendingType() == null){
            throw new ZTBusinessException("待办待阅不可为空");
        }
        if(reqBO.getType() == null){
            throw new ZTBusinessException("入参待办来源不可为空");
        }
        if(reqBO.getTitle() == null){
            throw new ZTBusinessException("入参待办标题不可为空");
        }
        if(reqBO.getClazz() == null){
            throw new ZTBusinessException("入参待办类型名称不可为空");
        }
        if(reqBO.getPcUrl() == null){
            throw new ZTBusinessException("入参pc访问路径不可为空");
        }
//        if(reqBO.getRawData() == null){
//            throw new ZTBusinessException("入参请求参数不可为空");
//        }
        if(reqBO.getPushType() == null){
            throw new ZTBusinessException("入参推送类型不可为空");
        }

    }
}
