package com.tydic.dict.system.repository.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.authority.common.rsp.DictResult;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dict.system.repository.dao.DictAuditTaskTodoMapper;
import com.tydic.dict.system.repository.rsp.AuditTodoListResponse;
import com.tydic.dict.system.repository.service.search.DictAuditTodoSearchService;
import com.tydic.dict.system.service.bo.*;
import com.tydic.dict.system.service.common.DictAuditTodoTypeEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class DictAuditTodoSearchServiceImpl implements DictAuditTodoSearchService {

    @Autowired
    private DictAuditTaskTodoMapper dictAuditTaskTodoMapper;

    @Override
    public AuditTodoListResponse<DictAuditTodoRspBO> list(DictAuditTodoQryReqBO bo) {
        // 创建分页对象
        Page<DictAuditTodoRspBO> page = new Page<>(bo.getPageNo(), bo.getPageSize());

        String orderBy;
        if (Objects.isNull(bo.getStatus()) || !bo.getStatus()) {
            orderBy = "create_date";
        } else {
            orderBy = "update_date";
        }
        // 执行分页查询
        Page<DictAuditTodoRspBO> pageResult = dictAuditTaskTodoMapper.page(bo, orderBy, page);

        if (CollectionUtils.isNotEmpty(pageResult.getRecords())) {
            pageResult.getRecords().forEach(rspBO -> rspBO.setType(DictAuditTodoTypeEnum.getDesByCode(rspBO.getType())));
        }

        // 获取待办和已办数量
        Map<String, Long> statusCounts = dictAuditTaskTodoMapper.countByStatus(bo.getUserId());

        // 封装结果
        int pageNo = (int) pageResult.getCurrent();
        int pageSize = (int) pageResult.getSize();
        List<DictAuditTodoRspBO> records = pageResult.getRecords();
        long total = pageResult.getTotal();
        long todoCount = statusCounts.getOrDefault("todo_count", 0L);
        long doneCount = statusCounts.getOrDefault("done_count", 0L);
        long toBeReadCount = statusCounts.getOrDefault("to_be_read_count", 0L);
        long readCount = statusCounts.getOrDefault("read_count", 0L);

        AuditTodoListResponse<DictAuditTodoRspBO> response = AuditTodoListResponse.newInstance(pageNo, pageSize, records, total, todoCount, doneCount, toBeReadCount, readCount);
        return response;
    }

    @Override
    public DictAuditTodoRspBO detail(DictAuditTodoQryDetailReqBO reqBO) {
        DictAuditTodoRspBO dictAuditTodoRspBO = dictAuditTaskTodoMapper.selectByPendingCode(Long.valueOf(reqBO.getPendingCode()));
        if (Objects.nonNull(dictAuditTodoRspBO)) {
            dictAuditTodoRspBO.setType(DictAuditTodoTypeEnum.getDesByCode(dictAuditTodoRspBO.getType()));
        }
        return dictAuditTodoRspBO;
    }

    @Override
    public DictResult<List<String>> cancelTradeIdList(DictAuditTaskTodoCancelReqBO reqBO) {
        if(StringUtils.isBlank(reqBO.getBusinessCode())){
            throw new ZTBusinessException("商机编码不可为空");
        }
        if(reqBO.getIsCancel() == null){
            throw new ZTBusinessException("是否作废不可为空");
        }
        return DictResult.success(dictAuditTaskTodoMapper.selectTradeIdBy(reqBO));
    }

    @Override
    public DictAuditTodoRspBO detailByTaskId(DictAuditTodoQryDetailReqBO reqBO) {
        if(StringUtils.isBlank(reqBO.getTaskId())){
            throw new ZTBusinessException("taskId不可为空");
        }
        return dictAuditTaskTodoMapper.selectByTaskId(reqBO.getTaskId());
    }

    @Override
    public List<DictAuditTodoRspBO> queryByCondition(DictAuditTaskTodoQryConditionReqBO reqBO) {
        List<DictAuditTodoRspBO> result = new ArrayList<>();
        if (Objects.nonNull(reqBO)) {
            result = dictAuditTaskTodoMapper.queryByCondition(reqBO);
        }
        return result;
    }
}
