package com.tydic.dict.system.repository.impl;

import com.alibaba.excel.util.StringUtils;
import com.google.common.collect.Maps;
import com.tydic.dict.system.repository.dao.DictDictionariesMapper;
import com.tydic.dict.system.repository.po.DictDictionariesPO;
import com.tydic.dict.system.repository.service.search.DictDictionarySearchService;
import com.tydic.dict.system.service.bo.DictDictionaryBatchQryByDicKeyReqBO;
import com.tydic.dict.system.service.bo.DictDictionaryQryByDicKeyReqBO;
import com.tydic.dict.system.service.bo.DictDictionaryQryByModuNameAndDicDirReqBO;
import com.tydic.dict.system.service.bo.DictDictionaryRspBO;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class DictDictionarySearchServiceImpl implements DictDictionarySearchService {

    @Autowired
    private DictDictionariesMapper dictDictionariesMapper;
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public List<DictDictionaryRspBO> searchByModuleNameAndDicDir(DictDictionaryQryByModuNameAndDicDirReqBO reqBO) {
        List<DictDictionaryRspBO> result = null;

        if (Objects.nonNull(reqBO)) {
            // 查询字典
            List<DictDictionariesPO> dictDictionariesPOS = dictDictionariesMapper.selectByModuleNameAndDicDir(reqBO);
            if (CollectionUtils.isNotEmpty(dictDictionariesPOS)) {
                // 以字典 parentDicKey 作为key 生成map （方便从外层遍历 生成父子结构)
                Map<String, List<DictDictionariesPO>> parentDicKeyMap = dictDictionariesPOS.stream().collect(Collectors.groupingBy(DictDictionariesPO::getParentDicKey, Collectors.collectingAndThen(Collectors.toList(),
                        list -> {
                            list.sort(Comparator.comparingInt(DictDictionariesPO::getOrder));
                            return list;
                        })));
                // 遍历 生成父子结构 (第一层的 parentDicKey 为 null 给个默认值 -1)
                result = parentDicKeyMap.get("-1").stream().map(dictionariesPO -> {
                    DictDictionaryRspBO dicRspBO = new DictDictionaryRspBO();
                    dicRspBO.setValue(dictionariesPO.getDicKey());
                    dicRspBO.setLabel(dictionariesPO.getDicValue());
                    dicRspBO.setParentCode(null);
                    // 获取子节点
                    dicRspBO.setChildren(this.getChildren(parentDicKeyMap.get(dictionariesPO.getDicKey()), parentDicKeyMap));

                    return dicRspBO;
                }).collect(Collectors.toList());
            }

        }
        return result;
    }

    @Override
    public DictDictionaryRspBO searchByDicKey(DictDictionaryQryByDicKeyReqBO reqBO) {
        DictDictionaryRspBO result = null;

        if (Objects.nonNull(reqBO) && StringUtils.isNotBlank(reqBO.getDicKey())) {
            // 查询字典
            DictDictionariesPO dictDictionariesPO = dictDictionariesMapper.selectByDicKey(reqBO.getDicKey());
            if (Objects.nonNull(dictDictionariesPO)) {
                result = new DictDictionaryRspBO();
                result.setValue(dictDictionariesPO.getDicKey());
                result.setLabel(dictDictionariesPO.getDicValue());
                result.setParentCode(null);

            }
        }
        return result;
    }

    @Override
    public Map<String, String> batchSearchByDicKey(DictDictionaryBatchQryByDicKeyReqBO reqBO) {
        Map<String, String> result = Maps.newHashMap();

        if (Objects.nonNull(reqBO) && CollectionUtils.isNotEmpty(reqBO.getDicKeys())) {
            List<String> dicKeys = reqBO.getDicKeys().stream().filter(org.apache.commons.lang3.StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(dicKeys)) {
                // 查询字典
                List<DictDictionariesPO> dictDictionariesPOList = dictDictionariesMapper.selectByDicKeys(dicKeys);
                if (CollectionUtils.isNotEmpty(dictDictionariesPOList)) {
                    result = dictDictionariesPOList.stream().collect(Collectors.toMap(DictDictionariesPO::getDicKey, DictDictionariesPO::getDicValue, (v1, v2) -> v2));
                }
            }
        }
        return result;
    }

    private List<DictDictionaryRspBO> getChildren
            (List<DictDictionariesPO> dictDictionariesPOS, Map<String, List<DictDictionariesPO>> parentDicKeyMap) {
        List<DictDictionaryRspBO> children = null;
        if (CollectionUtils.isNotEmpty(dictDictionariesPOS)) {
            children = dictDictionariesPOS.stream().map(dictionariesPO -> {
                DictDictionaryRspBO dicRspBO = new DictDictionaryRspBO();
                dicRspBO.setValue(dictionariesPO.getDicKey());
                dicRspBO.setLabel(dictionariesPO.getDicValue());
                dicRspBO.setParentCode(dictionariesPO.getParentDicKey());
                // 递归获取子节点
                dicRspBO.setChildren(this.getChildren(parentDicKeyMap.get(dictionariesPO.getDicKey()), parentDicKeyMap));

                return dicRspBO;
            }).collect(Collectors.toList());
        }
        return children;
    }
}
