package com.tydic.dict.system.repository.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ohaotian.authority.common.rsp.DictResult;
import com.tydic.dict.system.repository.dao.DictHomeMenuQuickEntryMapper;
import com.tydic.dict.system.repository.po.DictHomeMenuQuickEntryPo;
import com.tydic.dict.system.repository.service.search.DictHomeMenuQuickEntrySearchService;
import com.tydic.dict.system.service.bo.DictHomeMenuQuickEntryRspBo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service
@Slf4j
public class DictHomeMenuQuickEntrySearchServiceImpl extends ServiceImpl<DictHomeMenuQuickEntryMapper, DictHomeMenuQuickEntryPo> implements DictHomeMenuQuickEntrySearchService {

    @Autowired
    private DictHomeMenuQuickEntryMapper dictHomeMenuQuickEntryMapper;

    @Override
    public DictResult<List<DictHomeMenuQuickEntryRspBo>> selectList() {
        List<DictHomeMenuQuickEntryPo> poList = dictHomeMenuQuickEntryMapper.selectList(
                Wrappers.<DictHomeMenuQuickEntryPo>lambdaQuery()
                        .eq(DictHomeMenuQuickEntryPo::getVisible, 1)
        );
        if (CollectionUtil.isEmpty(poList)) {
            log.error("数据不存在: {}", poList);
            return DictResult.error(null, "数据不存在");
        }
        List<DictHomeMenuQuickEntryRspBo> rspBoList = poList.stream()
                .map(po -> BeanUtil.copyProperties(po, DictHomeMenuQuickEntryRspBo.class))
                .collect(Collectors.toList());
        return DictResult.success(rspBoList);
    }

    @Override
    public DictResult listSort(List<DictHomeMenuQuickEntryRspBo> req) {
        if(!CollectionUtils.isEmpty(req)){
            List<DictHomeMenuQuickEntryPo> data =new ArrayList<>();
            req.forEach(item->{
                DictHomeMenuQuickEntryPo po = this.getById(item.getId());
                if(po != null){
                    BeanUtil.copyProperties(item,po);
                    po.setUpdatedTime(new Date());
                    data.add(po);
                }
            });
            this.updateBatchById(data);
        }
        return DictResult.success();
    }
}
