package com.tydic.dict.system.repository.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ohaotian.authority.common.rsp.DictResult;
import com.tydic.dict.system.repository.dao.DictHomeMenuQuickEntryMapper;
import com.tydic.dict.system.repository.po.DictHomeMenuQuickEntryPo;
import com.tydic.dict.system.repository.service.update.DictHomeMenuQuickEntryUpdateService;
import com.tydic.dict.system.service.bo.DictHomeMenuQuickEntryReqBo;
import com.tydic.dict.system.service.constants.HomeConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
@Slf4j
public class DictHomeMenuQuickEntryUpdateServiceImpl extends ServiceImpl<DictHomeMenuQuickEntryMapper, DictHomeMenuQuickEntryPo> implements DictHomeMenuQuickEntryUpdateService {

    @Autowired
    private DictHomeMenuQuickEntryMapper dictHomeMenuQuickEntryMapper;

    @Override
    public DictResult<String> add(DictHomeMenuQuickEntryReqBo req) {
        if (req == null) {
            return DictResult.error(null, "参数为空");
        }
        List<DictHomeMenuQuickEntryPo> poList = dictHomeMenuQuickEntryMapper.selectList(Wrappers.<DictHomeMenuQuickEntryPo>lambdaQuery()
                .eq(DictHomeMenuQuickEntryPo::getVisible, 1)
                .eq(DictHomeMenuQuickEntryPo::getDeleted, false));
        if (poList.size() > HomeConstant.QUICK_ENTRY_CAPACITY) {
            return DictResult.error(null, "已经达到上限, 无法添加");
        }
        DictHomeMenuQuickEntryPo po = BeanUtil.copyProperties(req, DictHomeMenuQuickEntryPo.class);
        // todo
//        po.setCreatedBy(req.getName());
//        po.setUpdatedBy(req.getName());
        po.setCreatedBy("admin");
        po.setUpdatedBy("admin");
        boolean result = this.save(po);
        if (result) {
            return DictResult.success("添加成功");
        }
        return DictResult.error(null, "添加失败");
    }

    @Override
    public DictResult<String> delete(Long id) {
        if (id != null) {
            DictHomeMenuQuickEntryPo po = this.getById(id);
            if (po == null) {
                return DictResult.error(null, "数据不存在");
            }
            po.setSort(HomeConstant.QUICK_ENTRY_INIT_SORT);
            boolean result = this.removeById(id);
            if (result) {
                return DictResult.success("删除成功");
            } else {
                return DictResult.error(null, "删除失败");
            }
        }
        return DictResult.error(null, "参数为空");
    }

    @Override
    public DictResult<String> change(DictHomeMenuQuickEntryReqBo req) {
        if (req != null) {
            DictHomeMenuQuickEntryPo po = this.getById(req.getId());
            if (po == null) {
                return DictResult.error(null, "数据不存在");
            }
            // todo
            //po.setUpdatedBy(req.getName());
            po.setUpdatedBy("admin");
            po.setUpdatedTime(new Date());
            BeanUtil.copyProperties(req, po);
            boolean result = this.updateById(po);
            if (result) {
                return DictResult.success("修改成功");
            } else {
                return DictResult.error(null, "修改失败");
            }
        }
        return DictResult.error(null, "参数为空");
    }

}
