/**
 * @(#)DictWarningMsgServiceImpl.java Created by wyp on 2024/9/8   18:52
 * <p>
 * Copyrights (C) 2024保留所有权利
 */

package com.tydic.dict.system.repository.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ohaotian.authority.common.rsp.DictPage;
import com.tydic.dict.system.repository.dao.DictWarningMsgMapper;
import com.tydic.dict.system.repository.po.DictWarningMsgPO;
import com.tydic.dict.system.repository.service.search.DictWarningMsgSearchService;
import com.tydic.dict.system.service.bo.DictWarningMsgListReqBO;
import com.tydic.dict.system.service.bo.DictWarningMsgRspBO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * (类型功能说明描述)
 *
 * <p>
 * 修改历史:                                 <br>
 * 修改日期           修改人员       版本       修改内容<br>
 * -------------------------------------------------<br>
 * 2024/9/8 18:52   wyp     1.0       初始化创建<br>
 * </p>
 *
 * @author wyp
 * @version 1.0
 * @since JDK1.8
 */
@Service
@Slf4j
public class DictWarningMsgSearchServiceImpl extends ServiceImpl<DictWarningMsgMapper, DictWarningMsgPO> implements DictWarningMsgSearchService {

    @Autowired
    private DictWarningMsgMapper dictWarningMsgMapper;

    @Override
    public DictPage<DictWarningMsgRspBO> list(DictWarningMsgListReqBO reqBO) {
        if (StringUtils.isNotBlank(reqBO.getWarningNo())) {
            reqBO.setWarningNo("%" + reqBO.getWarningNo() + "%");
        }
        if (StringUtils.isNotBlank(reqBO.getWarningContent())) {
            reqBO.setWarningContent("%" + reqBO.getWarningContent() + "%");
        }
        if (StringUtils.isNotBlank(reqBO.getWarningType())) {
            reqBO.setWarningType("%" + reqBO.getWarningType() + "%");
        }
        String startTime = null;
        if (Objects.nonNull(reqBO.getCreateTimeStart())) {
            startTime = DateUtil.formatDateTime(DateUtil.beginOfDay(reqBO.getCreateTimeStart()));
        }
        String endTime = null;
        if (Objects.nonNull(reqBO.getCreateTimeEnd())) {
            endTime = DateUtil.formatDateTime(DateUtil.beginOfDay(reqBO.getCreateTimeEnd()));
        }
        Page<DictWarningMsgRspBO> pageData = dictWarningMsgMapper.searchByCondition(reqBO, startTime, endTime, new Page<>(reqBO.getPageNo(), reqBO.getPageSize()));
        return DictPage.newInstance(reqBO.getPageNo(), reqBO.getPageSize(), pageData.getRecords(), pageData.getTotal());
    }
}
