package com.tydic.dict.system.repository.po;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 信息中心表
 * </p>
 *
 * @author liliang
 * @since 2024-09-15
 */
@Getter
@Setter
@TableName("dict_message_center_info")
public class DictMessageCenterInfoPO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 消息内容
     */
    @TableField("message_content")
    private String messageContent;

    /**
     * 接收人用户id
     */
    @TableField("receive_user_id")
    private Long receiveUserId;

    /**
     * 是否已读 0-未读 1-已读
     */
    @TableField("read")
    private Boolean read;

    /**
     * 是否删除 0-未删除 1-已删除
     */
    @TableField("deleted")
    private Boolean deleted;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private Date updateTime;

    /**
     * 创建人
     */
    @TableField("create_by")
    private String createBy;

    /**
     * 编辑人
     */
    @TableField("update_by")
    private String updateBy;

}
