package com.tydic.dict.system.repository.task;

import cn.hutool.core.date.DateTime;
import com.tydic.dict.system.repository.service.search.DictAnnouncementSearchService;
import com.tydic.dict.system.repository.service.update.DictAnnouncementUpdateService;
import com.tydic.dict.system.service.bo.DictAnnouncementRspBo;
import com.tydic.dict.system.service.bo.DictAnnouncementUpdateTopStatusReqBO;
import com.tydic.dict.system.service.constants.HomeConstant;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Component
public class DictAnnouncementTask {

    @Autowired
    private DictAnnouncementSearchService dictAnnouncementSearchService;
    @Autowired
    private DictAnnouncementUpdateService dictAnnouncementUpdateService;

    @XxlJob("updateAnnouncementTopStatusTask")
    public void updateAnnouncementTopStatusTask() {

        XxlJobHelper.log("update announcement top status task start....");

        // 获取当前日期
        DateTime now = DateTime.now();

        XxlJobHelper.log("get announcement list....");
        List<DictAnnouncementRspBo> dictAnnouncementRspBos = dictAnnouncementSearchService.selectList();
        XxlJobHelper.log("get [{}] announcement....", dictAnnouncementRspBos.size());

        if (CollectionUtils.isNotEmpty(dictAnnouncementRspBos)) {
            XxlJobHelper.log("handle announcement top status....", dictAnnouncementRspBos.size());
            List<DictAnnouncementUpdateTopStatusReqBO> updateList = dictAnnouncementRspBos.stream().filter(rspBO -> Objects.nonNull(rspBO.getStartTime()) && Objects.nonNull(rspBO.getEndTime())).map(rspBO -> {
                DictAnnouncementUpdateTopStatusReqBO updateTopStatusReqBO = new DictAnnouncementUpdateTopStatusReqBO();
                updateTopStatusReqBO.setId(rspBO.getId());
                if (now.isAfterOrEquals(rspBO.getStartTime()) && now.isBeforeOrEquals(rspBO.getEndTime())) {
                    // 置顶时间有效，设置为置顶
                    updateTopStatusReqBO.setTopStatus(HomeConstant.ANNOUNCEMENT_TOP);
                } else {
                    // 置顶时间无效，取消置顶
                    updateTopStatusReqBO.setTopStatus(HomeConstant.ANNOUNCEMENT_NO_TOP);
                }
                return updateTopStatusReqBO;
            }).collect(Collectors.toList());
            XxlJobHelper.log("need update [{}] announcement top status...", updateList.size());
            dictAnnouncementUpdateService.batchUpdateStatus(updateList);
            XxlJobHelper.log("update [{}] announcement top status success...", updateList.size());
        }
        XxlJobHelper.log("update announcement top status task end....“");
    }
}

