package com.tydic.dict.system.repository.util;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/**
 * 密码生成工具类
 */
public class PasswordGenerator {
    private static final String LOWER_CASE = "abcdefghijklmnopqrstuvwxyz";
    private static final String UPPER_CASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String NUMBERS = "0123456789";
    private static final String SPECIAL_CHARACTERS = "!@#$%^&*";

    public static String generatePassword() {
        Random random = new Random();

        // 确保密码中包含至少一个大写字母、一个小写字母、一个数字和一个特殊字符
        StringBuilder passwordBuilder = new StringBuilder();
        passwordBuilder.append(getRandomCharacter(LOWER_CASE, random));
        passwordBuilder.append(getRandomCharacter(UPPER_CASE, random));
        passwordBuilder.append(getRandomCharacter(NUMBERS, random));
        passwordBuilder.append(getRandomCharacter(SPECIAL_CHARACTERS, random));

        // 剩余部分填充随机字符
        String allCategories = LOWER_CASE + UPPER_CASE + NUMBERS + SPECIAL_CHARACTERS;
        int remainingLength = 8 - passwordBuilder.length();
        while (remainingLength > 0) {
            passwordBuilder.append(getRandomCharacter(allCategories, random));
            remainingLength--;
        }

        // 打乱字符顺序，避免出现连续或重复的模式
        List<Character> shuffledChars = IntStream.range(0, passwordBuilder.length())
                .mapToObj(i -> passwordBuilder.charAt(i))
                .collect(Collectors.toList());
        Collections.shuffle(shuffledChars);
        return shuffledChars.stream()
                .map(String::valueOf)
                .collect(Collectors.joining());
    }

    /**
     * 从指定的字符集中获取随机字符
     *
     * @param category 字符集
     * @param random   随机数生成器
     * @return 返回随机字符
     */
    private static char getRandomCharacter(String category, Random random) {
        int index = random.nextInt(category.length());
        return category.charAt(index);
    }
}
