package com.tydic.dict.exception;


public class BusiException extends Exception{

	private static final long serialVersionUID = -238226337629844783L;
	/** 异常编码 */
	private String exceptionCode;
	/** 异常描述 */
	private String exceptionDesc;

	public BusiException(String exceptionCode, String exceptionDesc) {
		super(exceptionDesc);
		this.exceptionCode = exceptionCode;
		this.exceptionDesc = exceptionDesc;
	}

	public BusiException(String exceptionCode, String exceptionDesc,
                         Throwable cause) {
		super(exceptionDesc, cause);
		this.exceptionCode = exceptionCode;
		this.exceptionDesc = exceptionDesc;
	}

	public String getExceptionCode() {
		return exceptionCode;
	}

	public String getExceptionDesc() {
		return exceptionDesc;
	}

	public String getExceptionInfo() {
		return "exceptionCode:" + this.exceptionCode + ",exceptionDesc:"
				+ this.exceptionDesc;
	}
}
