package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.QueryBasicProjectInfoUnifiedService;
import com.tydic.dict.service.course.bo.BasicProjectInformationUnifiedReqBO;
import com.tydic.dict.service.course.bo.InfoProjectPrimaryRspBO;
import com.tydic.dict.service.course.servDu.BasicProjectInfoUnifiedServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @program: markedeve-service-udp
 * @ClassName: QueryBasicProjectInfoUnifiedServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-03-21 10:19
 */
@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class BasicProjectInfoUnifiedServDuImpl implements BasicProjectInfoUnifiedServDu {

    private final QueryBasicProjectInfoUnifiedService queryBasicProjectInfoUnifiedService;
    @Override
    public InfoProjectPrimaryRspBO queryProjectInfoByCondition(BasicProjectInformationUnifiedReqBO reqBO) {
        log.info("-------[BasicProjectInfoUnifiedServDuImpl-queryProjectInfoByCondition]-------，入参{}", reqBO.toString());
        InfoProjectPrimaryRspBO rspBO = new InfoProjectPrimaryRspBO();
        try {
            rspBO = queryBasicProjectInfoUnifiedService.queryProjectInfoByCondition(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[BasicProjectInfoUnifiedServDuImpl-queryProjectInfoByCondition]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
