package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.BatchPreReviewService;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.BatchPreReviewReqBO;
import com.tydic.dict.service.course.bo.BatchPreReviewRspBO;
import com.tydic.dict.service.course.bo.InfoDemandTabulationRspBO;
import com.tydic.dict.service.course.servDu.BatchPreReviewServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

/**
 * @program: markedeve-service-udp
 * @ClassName: BatchPreReviewServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-03-04 14:17
 */
@HTServiceImpl
@Slf4j
public class BatchPreReviewServDuImpl implements BatchPreReviewServDu {

    @Resource
    private BatchPreReviewService batchPreReviewService;

    @Override
    public BatchPreReviewRspBO queryBatchPreReview(BatchPreReviewReqBO reqBO) {
        log.info("-------[BatchPreReviewServDuImpl-queryBatchPreReview]-------，入参{}", reqBO.toString());
        BatchPreReviewRspBO rspBO = new BatchPreReviewRspBO();
        try {
            rspBO = batchPreReviewService.queryBatchPreReview(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[BatchPreReviewServDuImpl-queryBatchPreReview]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO doBatchPreReviewSubmit(BatchPreReviewReqBO reqBO) {
        log.info("-------[BatchPreReviewServDuImpl-doBatchPreReviewSubmit]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = batchPreReviewService.doBatchPreReviewSubmit(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[BatchPreReviewServDuImpl-doBatchPreReviewSubmit]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
