package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.CodeAreaService;
import com.tydic.dict.service.course.bo.QueryCodeAreaReqBO;
import com.tydic.dict.service.course.bo.QueryCodeAreaRspBO;
import com.tydic.dict.service.course.servDu.CodeAreaServDu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

/**
 * @description:
 * @author: wangchao
 * @create: 2024-06-20 17:56
 **/
@HTServiceImpl
@Slf4j
public class CodeAreaServDuImpl implements CodeAreaServDu {

    @Autowired
    private CodeAreaService codeAreaService;

    @Override
    public QueryCodeAreaRspBO queryAreaListByParentAreaCode(QueryCodeAreaReqBO reqBO) {
        log.info("------[CodeAreaServDuImpl-queryAreaListByParentAreaCode接口被调用，入参为：{}]------", reqBO.toString());
        QueryCodeAreaRspBO rspBO = new QueryCodeAreaRspBO();
        if (!StringUtils.hasText(reqBO.getParentAreaCode())){
            rspBO.setRespCode("0000");
        }
        try {
            rspBO = codeAreaService.queryAreaListByParentAreaCode(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("-----[调用codeAreaService服务异常，异常原因为：{}-----", e.getMessage());
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("调用infoOutsourcingPersonService服务异常，异常原因为：" + e.getMessage());
        }
        log.info("------[CodeAreaServDuImpl-queryAreaListByParentAreaCode接口被调用，出参为：{}]------", rspBO.toString());
        return rspBO;
    }
}
