package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.CodeDepartAdminService;
import com.tydic.dict.service.course.bo.CodeDepartAdminReqBO;
import com.tydic.dict.service.course.bo.CodeDepartAdminRspBO;
import com.tydic.dict.service.course.bo.InfoSoftwareRspBO;
import com.tydic.dict.service.course.servDu.CodeDepartAdminServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

/**
 * @program: markedeve-service-udp
 * @ClassName: CodeDepartAdminServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-03-12 22:04
 */
@HTServiceImpl
@Slf4j
public class CodeDepartAdminServDuImpl implements CodeDepartAdminServDu {

    @Resource
    private CodeDepartAdminService codeDepartAdminService;

    @Override
    public CodeDepartAdminRspBO queryCodeDepartAdminPageList(CodeDepartAdminReqBO reqBO) {
        log.info("-------[CodeDepartAdminServDuImpl-queryCodeDepartAdminPageList]-------，入参{}", reqBO.toString());
        CodeDepartAdminRspBO rspBO = new CodeDepartAdminRspBO();
        try {
            rspBO = codeDepartAdminService.queryCodeDepartAdminPageList(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[CodeDepartAdminServDuImpl-queryCodeDepartAdminPageList]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public CodeDepartAdminRspBO queryCodeDepartAdminList(CodeDepartAdminReqBO codeDepartAdminReqBO) {
        log.info("-------[CodeDepartAdminServDuImpl-queryCodeDepartAdminList]-------，入参{}", codeDepartAdminReqBO.toString());
        CodeDepartAdminRspBO rspBO = new CodeDepartAdminRspBO();
        try {
            rspBO = codeDepartAdminService.queryCodeDepartAdminList(codeDepartAdminReqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[CodeDepartAdminServDuImpl-queryCodeDepartAdminList]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public CodeDepartAdminRspBO queryCodeDepartAdminByTaskIdAdminTypeList(CodeDepartAdminReqBO codeDepartAdminReqBO) {
        log.info("-------[CodeDepartAdminServDuImpl-queryCodeDepartAdminByTaskIdAdminTypeList]-------，入参{}", codeDepartAdminReqBO.toString());
        CodeDepartAdminRspBO rspBO = new CodeDepartAdminRspBO();
        try {
            rspBO = codeDepartAdminService.queryCodeDepartAdminByTaskIdAdminTypeList(codeDepartAdminReqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[CodeDepartAdminServDuImpl-queryCodeDepartAdminByTaskIdAdminTypeList]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
