package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.CodeListService;
import com.tydic.dict.service.course.bo.CodeListReqBO;
import com.tydic.dict.service.course.bo.CodeListRspBO;
import com.tydic.dict.service.course.servDu.CodeListServDu;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * @Description:
 * @Author: xsl
 * @Date: 2024/2/5 17:26
 */
@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class CodeListServDuImpl implements CodeListServDu {

    private final CodeListService codeListService;

    @Override
    public CodeListRspBO queryCodeList(CodeListReqBO reqBO) {
        log.info("-----------------[CodeListServDuImpl.queryCodeList] 入参{}",reqBO.toString());
        return codeListService.queryCodeList(reqBO);
    }

    @Override
    public CodeListRspBO getRedisCacheData(CodeListReqBO reqBO) {
        log.info("-----------------[CodeListServDuImpl.getRedisCacheData] 入参{}",reqBO.toString());
        return codeListService.getRedisCacheData(reqBO);
    }

    @Override
    public CodeListRspBO resetRedisCacheData(CodeListReqBO reqBO) {
        log.info("-----------------[CodeListServDuImpl.resetRedisCacheData] 入参{}",reqBO.toString());
        return codeListService.resetRedisCacheData(reqBO);
    }

    @Override
    public CodeListRspBO getNumberGen(CodeListReqBO reqBO) {
        return codeListService.getNumberGen(reqBO);
    }
}
