package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.CodeTaskAssignRuleService;
import com.tydic.dict.service.course.bo.CodeTaskAssignRuleByGatewayRspBO;
import com.tydic.dict.service.course.bo.CodeTaskAssignRuleReqBO;
import com.tydic.dict.service.course.bo.CodeTaskAssignRuleRspBO;
import com.tydic.dict.service.course.bo.InfoDemandDetailsUpdateOperationRspBO;
import com.tydic.dict.service.course.servDu.CodeTaskAssignRuleServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class CodeTaskAssignRuleServDuImpl implements CodeTaskAssignRuleServDu {

    private final CodeTaskAssignRuleService codeTaskAssignRuleService;

    @Override
    public CodeTaskAssignRuleRspBO queryTaskAssignUserInfo(CodeTaskAssignRuleReqBO reqBO) {
        log.info("-------[CodeTaskAssignRuleServDuImpl-queryTaskAssignUserInfo被调用]-------，入参{}", reqBO.toString());
        CodeTaskAssignRuleRspBO rspBO = new CodeTaskAssignRuleRspBO();
        try {
            rspBO = codeTaskAssignRuleService.queryTaskAssignUserInfo(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setCode("1");
            rspBO.setMessage("异常：" + e.getMessage());
        }
        return rspBO;
    }

    @Override
    public CodeTaskAssignRuleByGatewayRspBO queryTaskAssignUserInfoByGateway(CodeTaskAssignRuleReqBO reqBO) {
        /*log.info("-------[CodeTaskAssignRuleServDuImpl-queryTaskAssignUserInfoByGateway被调用]-------，入参{}", reqBO.toString());
        CodeTaskAssignRuleByGatewayRspBO rspBO = new CodeTaskAssignRuleByGatewayRspBO();
        try {
            rspBO = codeTaskAssignRuleService.queryTaskAssignUserInfo(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        return rspBO;*/
        return null;
    }
}
